/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import org.broad.igv.util.FilterElement;
import org.broad.igv.util.FilterElement.BooleanOperator;
import org.broad.igv.util.FilterElement.Operator;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;

/**
 *
 * @author eflakes
 */
public class TrackFilterElement extends FilterElement {

    public TrackFilterElement(TrackFilter filter, String item, 
            Operator comparisonOperator, String value, 
            BooleanOperator booleanOperator) {
        
        super(filter, item, comparisonOperator, value, booleanOperator);
    }
    
    public boolean evaluate(Track track, Boolean previousResult) {
        
        String attributeKey = getSelectedItem();
        AttributeManager manager = AttributeManager.getInstance();
        String attribute = track.getAttributeValue(attributeKey);
        
        return super.test(attribute, previousResult);
    }
    
}
