/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import java.util.List;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;
import org.broad.igv.util.FilterElement.BooleanOperator;
import org.broad.igv.util.FilterElement.Operator;
import org.broad.igv.ui.util.FilterComponent;
/**
 *
 * @author eflakes
 */
public class TrackFilterComponent extends FilterComponent {

    private boolean matchAll = true;
    
    public TrackFilterComponent(TrackFilterPane filterPane, String text, List<String> items, 
            FilterElement element) {
        
        super(filterPane, text, items, element);
    }
    
    public TrackFilterElement createFilterElement(Filter filter, String selectedItem, 
        Operator comparisonOperator, String value, BooleanOperator booleanOperator ) {
        
            TrackFilterElement filterElement = 
                new TrackFilterElement (
                    (TrackFilter)filter, 
                    selectedItem, 
                    comparisonOperator, 
                    value, 
                    booleanOperator);
            
        return filterElement;
    }    
    
    public void setMatchAll(boolean value) {
        matchAll = value;
    }
    
    public boolean getMatchAll() {
        return matchAll;
    }
    
    /**
     * Save the UI content into a non-UI version of the FilterElement
     */
    public void save() {

        FilterElement filterElement = getFilterElement();
        
        // Boolean operator
        if(matchAll) {
            filterElement.setBooleanOperator(BooleanOperator.AND);
        }
        else {
            filterElement.setBooleanOperator(BooleanOperator.OR);
        }
        
        super.save();
    }
    
}
