/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.broad.igv.util.Filter;
import org.broad.igv.util.FilterElement;
import org.broad.igv.track.Track;

/**
 *
 * @author eflakes
 */
public class TrackFilter extends Filter {
    
    private boolean showAll = false;
    
    List<Track> currentTrackList;
    
    public TrackFilter(String name, List<TrackFilterElement> elements) {
        super(name, elements);
    }
    
    public void clearTracks() {
        currentTrackList = null;
    }
    
    public void addTracks(List<Track> tracks) {
        
        if(tracks == null || tracks.isEmpty()) 
            return;
        
        if(currentTrackList == null) {
            currentTrackList =  new ArrayList<Track>(tracks);
        }
    }
    
    /**
     * Evaluate the TrackFilterElement set.
     * @return
     */
    @Override
    public void evaluate() {
                        
        if(currentTrackList == null || currentTrackList.isEmpty() )
            return;
        
        boolean filterEnabled = isEnabled();
        
        for(Track track : currentTrackList) {
            
            // Must start as null which means no previous results
            Boolean result= null;

            // If filter is not enabled just show all tracks
            if(!filterEnabled) {
                track.setVisible(!filterEnabled);
                continue;
            }
            
            // Evaluate tracks
            Iterator iterator = getFilterElements();
            while(iterator.hasNext()) {

                FilterElement element = (FilterElement)iterator.next();
                result = element.evaluate(track, result);
            }
            track.setVisible(result);
        }        
    }

    public

    boolean isShowAll() {
        return showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }
}
