/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import java.io.File;
import javax.swing.JDialog;
import org.broad.igv.ui.util.FileChooserDialog;

/**
 *
 * @author eflakes
 */
public class ResourceFileBuilderDialog {

     /**
     * @param args the command line arguments
     */
    public static void main(String[] args) {

        LookAndFeelFactory.installDefaultLookAndFeel();

        FileChooserDialog dialog = new FileChooserDialog(null, true);
        dialog.setFileSelectionMode(FileChooserDialog.DIRECTORIES_ONLY);
        dialog.setTitle("Resource Folder Selection");
        dialog.setMultiSelectionEnabled(true);
        dialog.setSelectedFile(null);
        dialog.setDefaultCloseOperation(JDialog.EXIT_ON_CLOSE);
        dialog.setVisible(true);

        if (!dialog.isCanceled()) {

            File file = dialog.getSelectedFile();
            (new ResourceFileBuilder()).process(file);

        }
    }

}
