/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;

/**
 *
 * @author eflakes
 */
public class ResourceCheckBoxList extends JList {

    /**
     *  A Checkbox representation
     */
    public static class ResourceCheckBox extends JCheckBox {
        
        private URL resourceUrl;
        
        public ResourceCheckBox(String displayName, URL url) {
            super(displayName);
            resourceUrl = url;
        }

        public URL getResourceLocator() {
            return resourceUrl;
        }
    }
    
    public ResourceCheckBoxList(Object[] data) {
        super(data);
        setCellRenderer(new JListCellRenderer());
        setEnabled(true);
        addMouseListener(new MouseAdapter() {

            @Override
            public void mousePressed(MouseEvent e) {
                int index = locationToIndex(e.getPoint());
                if (index != -1) {
                    ResourceCheckBox resourceCheckBox =
                        (ResourceCheckBox) getModel().getElementAt(index);
                    resourceCheckBox.setSelected(!resourceCheckBox.isSelected());
                    repaint();
                }
            }
        });
    }
     
    /**
     * Renderer
     */
     class JListCellRenderer implements ListCellRenderer {

         public Component getListCellRendererComponent(JList list, Object value, 
               int index, boolean isSelected, boolean cellHasFocus)
         {
             ResourceCheckBox resourceCheckBox = (ResourceCheckBox)value;
             if (isSelected) {
                 resourceCheckBox.setBackground(list.getSelectionBackground());
                 resourceCheckBox.setForeground(list.getSelectionForeground());
             } else {
                 resourceCheckBox.setBackground(list.getBackground());
                 resourceCheckBox.setForeground(list.getForeground());
             }

             resourceCheckBox.setEnabled(list.isEnabled());
             resourceCheckBox.setFont(list.getFont());
             resourceCheckBox.setOpaque(true);
             return resourceCheckBox;
         }
     }
     
    public Set<URL> getSelectedURLs() {
        
        HashSet<URL> urls = new HashSet();
        ListModel model = ResourceCheckBoxList.this.getModel();
        int modelSize = model.getSize();
        for(int i = 0; i < modelSize; i++) {
            
            ResourceCheckBoxList.ResourceCheckBox resourceCheckBox =
                ((ResourceCheckBoxList.ResourceCheckBox)model.getElementAt(i));
            if(resourceCheckBox.isSelected()) {
                urls.add(resourceCheckBox.getResourceLocator());
            }
        }
        return urls;
    }     
}
