/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JButton;

/**
 *
 * @author eflakes
 */
public class RegionOfInterestTool extends IGVTool {

    RegionOfInterest regionOfInterest = null;
    Integer roiStart = null;
    JButton roiButton;

    public RegionOfInterestTool(Component owner, JButton roiButton) {
        super(owner, Cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
        this.roiButton = roiButton;
        setName("Region of Interest");
    }

    public int getRoiStart() {
        return (roiStart == null ? 0 : roiStart.intValue());
    }

    /**
     * The mouse has been clicked.  Define one edge of the region of interest.
     */
    @Override
    public void mousePressed(final MouseEvent e) {

        ViewContext viewContext = IGVModel.getInstance().getViewContext();

        if (e.getButton() == MouseEvent.BUTTON1 &&
                e.getClickCount() == 1) {

            Object chromosome = viewContext.getChromosome();

            // Allow Regions of Interest edits if ROI is enabled
            // and we have a valid Chromosome
            if (chromosome != null) {

                String chromosomeName = viewContext.getChrName();
                if (chromosomeName != null) {

                    int x = e.getX();
                    
                    // Create a user Region of Interest
                    if (roiStart == null) {
                        roiStart = (int) viewContext.getChromosomePosition(x);
                        getOwner().repaint();
                    } else {

                        try {

                            int roiEnd = (int) viewContext.getChromosomePosition(x);
                            int start = Math.min(roiStart, roiEnd);
                            int end = Math.max(roiStart, roiEnd);

                            if (start == end) {
                                ++end;
                            }

                            // Create a Region of Interest
                            regionOfInterest =
                                    new RegionOfInterest(
                                    chromosomeName,
                                    start,
                                    end,
                                    "ROI");
                            // TODO -- get this ugly reference out of here
                            IGVMainFrame.getInstance().endROI();
                            IGVMainFrame.getInstance().addRegionOfInterest(regionOfInterest);

                        } finally {
                            roiButton.setSelected(false);
                        }
                    }
                }

                IGVMainFrame.getInstance().doRefresh();
            }
        }
    }

    public RegionOfInterest getRegionOfInterest() {
        return regionOfInterest;
    }
}
