/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.ui;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Collection;
import javax.swing.JPanel;

/**
 *
 * @author eflakes
 */
public class RegionOfInterestPane extends JPanel {

    public RegionOfInterestPane() {
        
        //setToolTipText("<html>Use the left mouse click on a colored " +
        //    "Region of Interest<p>to show the popup menu.");  
    }
    
    @Override
    public void paintComponent(final Graphics g) {

        super.paintComponent(g);

        // Draw regions of interest?
        drawRegionsOfInterest((Graphics2D) g, getHeight());

        g.setColor(Color.BLACK);
        g.drawRect(0, 0, getWidth(), getHeight());
    }

    public void drawRegionsOfInterest(final Graphics2D g, int height) {

        ViewContext viewContext = IGVModel.getInstance().getViewContext();
        Collection<RegionOfInterest> regions =
            IGVModel.getInstance().getRegionsOfInterest(viewContext.getChrName());

        if (regions == null || regions.isEmpty()) {
            return;
        }


        for (RegionOfInterest regionOfInterest : regions) {

            Integer regionStart = regionOfInterest.getStart();
            if (regionStart == null) {
                // skip - null starts are bad regions of interest
                continue;
            }

            Integer regionEnd = regionOfInterest.getEnd();
            if (regionEnd == null) {
                regionEnd = regionStart;
            }
            int start = viewContext.getPixelPosition(regionStart);
            int end = viewContext.getPixelPosition(regionEnd);
            int regionWidth = Math.max(1, end - start);

            g.setColor(regionOfInterest.getBackgroundColor());
            g.setBackground(
                regionOfInterest.getBackgroundColor());
            g.fillRect(start, 0, regionWidth, height);

        }
    }
}
