/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.ui;

import org.broad.igv.ui.legend.LegendDialog;
import java.util.HashMap;
import java.util.Map;

/*
 * PreferencesEditor.java
 *
 * Created on April 25, 2008, 8:47 AM
 */
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.feature.ProbeToGeneMap;
import org.broad.igv.track.TrackManager;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.legend.ChromosomeColorLegend;

/**
 *
 * @author  jrobinso
 */
public class PreferencesEditor extends javax.swing.JDialog {

    private boolean canceled = false;
    Map<String, String> updatedPreferenceMap = new HashMap();
    PreferenceManager preferenceManager = PreferenceManager.getInstance();
    boolean updateOverlays = false;
    boolean inputValidated = true;
    int initialSamMaxLevel = 0;
    int initialSamQualityThreshold = 0;
    boolean initialShowDuplicates = false;
    private static int lastSelectedIndex = 0;

    /** Creates new form PreferencesEditor */
    public PreferencesEditor(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        initValues();

        tabbedPane.setSelectedIndex(lastSelectedIndex);
        setLocationRelativeTo(parent);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        featureStyleButtonGroup = new javax.swing.ButtonGroup();
        probeMappingButtonGroup = new javax.swing.ButtonGroup();
        rnaiMapapingButtonGroup = new javax.swing.ButtonGroup();
        tabbedPane = new javax.swing.JTabbedPane();
        generalPanel = new javax.swing.JPanel();
        jPanel10 = new javax.swing.JPanel();
        missingDataLabel = new javax.swing.JLabel();
        missingDataExplanation = new javax.swing.JLabel();
        showMissingDataCB = new javax.swing.JCheckBox();
        comginePanelLabel = new javax.swing.JLabel();
        combinePanelsCB = new javax.swing.JCheckBox();
        jLabel9 = new javax.swing.JLabel();
        joinSegmentsCB = new javax.swing.JCheckBox();
        missingDataExplanation1 = new javax.swing.JLabel();
        showAttributesDisplayLabel = new javax.swing.JLabel();
        showAttributesDisplayCheckBox = new javax.swing.JCheckBox();
        showAttributesDisplayDescription = new javax.swing.JLabel();
        tracksPanel = new javax.swing.JPanel();
        jPanel6 = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        defaultChartTrackHeightField = new javax.swing.JTextField();
        trackNameAttributeLabel = new javax.swing.JLabel();
        trackNameAttributeField = new javax.swing.JTextField();
        missingDataExplanation2 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        defaultTrackHeightField = new javax.swing.JTextField();
        missingDataExplanation4 = new javax.swing.JLabel();
        missingDataExplanation5 = new javax.swing.JLabel();
        overlaysPanel = new javax.swing.JPanel();
        jPanel5 = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        overlayAttributeTextField = new javax.swing.JTextField();
        overlayTrackCB = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        displayTracksCB = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        colorOverlyCB = new javax.swing.JCheckBox();
        chooseOverlayColorsButton = new com.jidesoft.swing.JideButton();
        chartPanel = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        topBorderCB = new javax.swing.JCheckBox();
        label1 = new java.awt.Label();
        chartDrawTrackNameCB = new javax.swing.JCheckBox();
        bottomBorderCB = new javax.swing.JCheckBox();
        jLabel7 = new javax.swing.JLabel();
        colorBordersCB = new javax.swing.JCheckBox();
        labelYAxisCB = new javax.swing.JCheckBox();
        alignmentPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        samMaxWindowSizeField = new javax.swing.JTextField();
        jLabel11 = new javax.swing.JLabel();
        samShowDuplicatesCB = new javax.swing.JCheckBox();
        jLabel12 = new javax.swing.JLabel();
        samFlagUnmappedPairCB = new javax.swing.JCheckBox();
        samShadeMismatchedBaseCB = new javax.swing.JCheckBox();
        jLabel13 = new javax.swing.JLabel();
        samMaxLevelField = new javax.swing.JTextField();
        jLabel14 = new javax.swing.JLabel();
        jLabel15 = new javax.swing.JLabel();
        mappingQualityThresholdField = new javax.swing.JTextField();
        jLabel16 = new javax.swing.JLabel();
        jLabel17 = new javax.swing.JLabel();
        insertSizeThresholdField = new javax.swing.JTextField();
        jLabel18 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jPanel2 = new ChromosomeColorLegend();
        autosortCB = new javax.swing.JCheckBox();
        samMinBaseQualityField = new javax.swing.JTextField();
        jLabel19 = new javax.swing.JLabel();
        jLabel20 = new javax.swing.JLabel();
        samMaxBaseQualityField = new javax.swing.JTextField();
        shadeCenteredAlignmentsCB = new javax.swing.JCheckBox();
        expressionPane = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        expMapToGeneCB = new javax.swing.JRadioButton();
        jLabel24 = new javax.swing.JLabel();
        expMapToLociCB = new javax.swing.JRadioButton();
        jLabel21 = new javax.swing.JLabel();
        advancedPanel = new javax.swing.JPanel();
        jPanel3 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        genomeServerURLTextField = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        dataServerURLTextField = new javax.swing.JTextField();
        editServerPropertiesCB = new javax.swing.JCheckBox();
        clearGenomeCacheButton = new javax.swing.JButton();
        okCancelButtonPanel = new com.jidesoft.dialog.ButtonPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setResizable(false);

        generalPanel.setLayout(null);

        missingDataLabel.setText("Distinguish Missing Data:"); // NOI18N

        missingDataExplanation.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation.setText("<html>Distinguish  regions with zero values from regions with no data on plots <br>(e.g. bar charts).  Regions with no data are indicated with a gray background."); // NOI18N

        showMissingDataCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showMissingDataCBActionPerformed(evt);
            }
        });

        comginePanelLabel.setText("Combine Data and Feature Panels:"); // NOI18N

        combinePanelsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                combinePanelsCBActionPerformed(evt);
            }
        });

        jLabel9.setText("Join Adjacent CopyNumber Segments:"); // NOI18N

        joinSegmentsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                joinSegmentsCBActionPerformed(evt);
            }
        });

        missingDataExplanation1.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation1.setText("<html>This option applies to segmented copy number data only.  When selected, gaps between<br>adjacent segments are filled by extending segment endpoints."); // NOI18N

        showAttributesDisplayLabel.setText("Show Attribute Display:"); // NOI18N

        showAttributesDisplayCheckBox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                showAttributesDisplayCheckBoxActionPerformed(evt);
            }
        });

        showAttributesDisplayDescription.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        showAttributesDisplayDescription.setText("<html>Determine whether the attribute header display is shown"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel10Layout = new org.jdesktop.layout.GroupLayout(jPanel10);
        jPanel10.setLayout(jPanel10Layout);
        jPanel10Layout.setHorizontalGroup(
            jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(42, 42, 42)
                        .add(showAttributesDisplayDescription))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(showAttributesDisplayLabel)
                        .add(26, 26, 26)
                        .add(showAttributesDisplayCheckBox))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(44, 44, 44)
                        .add(missingDataExplanation1))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(jLabel9)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(joinSegmentsCB))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(missingDataLabel)
                        .add(81, 81, 81)
                        .add(showMissingDataCB))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(35, 35, 35)
                        .add(missingDataExplanation))
                    .add(jPanel10Layout.createSequentialGroup()
                        .add(comginePanelLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(combinePanelsCB)))
                .addContainerGap(36, Short.MAX_VALUE))
        );
        jPanel10Layout.setVerticalGroup(
            jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel10Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(missingDataLabel)
                    .add(showMissingDataCB))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation)
                .add(26, 26, 26)
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(comginePanelLabel)
                    .add(combinePanelsCB))
                .add(13, 13, 13)
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel9)
                    .add(joinSegmentsCB))
                .add(11, 11, 11)
                .add(missingDataExplanation1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel10Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(showAttributesDisplayLabel)
                    .add(showAttributesDisplayCheckBox))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(showAttributesDisplayDescription)
                .addContainerGap(35, Short.MAX_VALUE))
        );

        generalPanel.add(jPanel10);
        jPanel10.setBounds(0, 0, 610, 290);

        tabbedPane.addTab("General", generalPanel);

        tracksPanel.setLayout(null);

        jLabel5.setText("Default Track Height, Charts (Pixels)"); // NOI18N

        defaultChartTrackHeightField.setText("40"); // NOI18N
        defaultChartTrackHeightField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultChartTrackHeightFieldActionPerformed(evt);
            }
        });
        defaultChartTrackHeightField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                defaultChartTrackHeightFieldFocusLost(evt);
            }
        });

        trackNameAttributeLabel.setText("Track Name Attribute"); // NOI18N

        trackNameAttributeField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                trackNameAttributeFieldActionPerformed(evt);
            }
        });
        trackNameAttributeField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                trackNameAttributeFieldFocusLost(evt);
            }
        });

        missingDataExplanation2.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation2.setText("<html>Name of an attribute to be used to label  tracks.  If provided tracks will be labeled with the corresponding attribute values from the sample information file"); // NOI18N

        jLabel8.setText("Default Track Height, Other (Pixels)"); // NOI18N

        defaultTrackHeightField.setText("15"); // NOI18N
        defaultTrackHeightField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                defaultTrackHeightFieldActionPerformed(evt);
            }
        });
        defaultTrackHeightField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                defaultTrackHeightFieldFocusLost(evt);
            }
        });

        missingDataExplanation4.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation4.setText("<html>Default height of chart tracks (barcharts, scatterplots, etc)"); // NOI18N

        missingDataExplanation5.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        missingDataExplanation5.setText("<html>Default height of all other tracks"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel6Layout = new org.jdesktop.layout.GroupLayout(jPanel6);
        jPanel6.setLayout(jPanel6Layout);
        jPanel6Layout.setHorizontalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(missingDataExplanation4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 354, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(missingDataExplanation2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 354, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(trackNameAttributeLabel)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(trackNameAttributeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 216, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(jLabel8)
                        .add(39, 39, 39)
                        .add(defaultTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 57, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(24, 24, 24)
                        .add(missingDataExplanation5, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE))
                    .add(jPanel6Layout.createSequentialGroup()
                        .add(jLabel5)
                        .add(36, 36, 36)
                        .add(defaultChartTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 57, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        jPanel6Layout.setVerticalGroup(
            jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel6Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel5)
                    .add(defaultChartTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation4, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel8)
                    .add(defaultTrackHeightField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 25, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(26, 26, 26)
                .add(jPanel6Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trackNameAttributeLabel)
                    .add(trackNameAttributeField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(missingDataExplanation2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 65, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(43, Short.MAX_VALUE))
        );

        missingDataExplanation2.getAccessibleContext().setAccessibleName("<html>Name of an attribute to be used to label  tracks.  If provided   <br>tracks will be labeled with the corresponding attribute values from the sample information file. ");

        tracksPanel.add(jPanel6);
        jPanel6.setBounds(40, 20, 540, 320);

        tabbedPane.addTab("Tracks", tracksPanel);

        jLabel3.setText("Overlay tracks based on attribute:"); // NOI18N

        overlayAttributeTextField.setText("LINKING_ID"); // NOI18N
        overlayAttributeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overlayAttributeTextFieldActionPerformed(evt);
            }
        });
        overlayAttributeTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                overlayAttributeTextFieldFocusLost(evt);
            }
        });
        overlayAttributeTextField.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                overlayAttributeTextFieldKeyTyped(evt);
            }
        });

        overlayTrackCB.setSelected(true);
        overlayTrackCB.setText("Overlay mutation tracks"); // NOI18N
        overlayTrackCB.setActionCommand("overlayTracksCB"); // NOI18N
        overlayTrackCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                overlayTrackCBActionPerformed(evt);
            }
        });

        jLabel2.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        jLabel2.setText(getOverlayText());

        displayTracksCB.setText("Display mutation data as distinct tracks"); // NOI18N
        displayTracksCB.setActionCommand("displayTracksCB"); // NOI18N
        displayTracksCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                displayTracksCBActionPerformed(evt);
            }
        });

        jLabel4.setFont(new java.awt.Font("Lucida Grande", 2, 12));

        colorOverlyCB.setText("Color code overlay"); // NOI18N
        colorOverlyCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorOverlyCBActionPerformed(evt);
            }
        });

        chooseOverlayColorsButton.setForeground(new java.awt.Color(0, 0, 247));
        chooseOverlayColorsButton.setText("Choose colors"); // NOI18N
        chooseOverlayColorsButton.setButtonStyle(
            com.jidesoft.swing.ButtonStyle.HYPERLINK_STYLE
        );
        chooseOverlayColorsButton.setFont(new java.awt.Font("Lucida Grande", 2, 12));
        chooseOverlayColorsButton.setVerticalAlignment(javax.swing.SwingConstants.BOTTOM);
        chooseOverlayColorsButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        chooseOverlayColorsButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chooseOverlayColorsButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel5Layout = new org.jdesktop.layout.GroupLayout(jPanel5);
        jPanel5.setLayout(jPanel5Layout);
        jPanel5Layout.setHorizontalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(displayTracksCB)
                    .add(jLabel4)
                    .add(overlayTrackCB)
                    .add(jLabel2)
                    .add(jPanel5Layout.createSequentialGroup()
                        .add(59, 59, 59)
                        .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel5Layout.createSequentialGroup()
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(colorOverlyCB)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(chooseOverlayColorsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jPanel5Layout.createSequentialGroup()
                                .add(jLabel3)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(overlayAttributeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 228, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))))
                .addContainerGap())
        );
        jPanel5Layout.setVerticalGroup(
            jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel5Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel4)
                .add(39, 39, 39)
                .add(overlayTrackCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel3)
                    .add(overlayAttributeTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(6, 6, 6)
                .add(jPanel5Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(colorOverlyCB)
                    .add(chooseOverlayColorsButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(36, 36, 36)
                .add(displayTracksCB)
                .addContainerGap(30, Short.MAX_VALUE))
        );

        org.jdesktop.layout.GroupLayout overlaysPanelLayout = new org.jdesktop.layout.GroupLayout(overlaysPanel);
        overlaysPanel.setLayout(overlaysPanelLayout);
        overlaysPanelLayout.setHorizontalGroup(
            overlaysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(overlaysPanelLayout.createSequentialGroup()
                .add(28, 28, 28)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(196, Short.MAX_VALUE))
        );
        overlaysPanelLayout.setVerticalGroup(
            overlaysPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(overlaysPanelLayout.createSequentialGroup()
                .add(55, 55, 55)
                .add(jPanel5, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(194, Short.MAX_VALUE))
        );

        tabbedPane.addTab("Overlays", overlaysPanel);

        chartPanel.setLayout(null);

        topBorderCB.setText("Draw Top Border");
        topBorderCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                topBorderCBActionPerformed(evt);
            }
        });

        label1.setFont(label1.getFont());
        label1.setText("Settings for barcharts and scatterplots:");

        chartDrawTrackNameCB.setText("Draw Track Label");
        chartDrawTrackNameCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chartDrawTrackNameCBActionPerformed(evt);
            }
        });

        bottomBorderCB.setText("Draw Bottom Border");
        bottomBorderCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bottomBorderCBActionPerformed(evt);
            }
        });

        jLabel7.setText("<html><i>Draw a label centered over the track provided<br>the track height is at least 25 pixels. ");

        colorBordersCB.setText("Color Borders");
        colorBordersCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                colorBordersCBActionPerformed(evt);
            }
        });

        labelYAxisCB.setText("Label Y Axis");
        labelYAxisCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                labelYAxisCBActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel4Layout = new org.jdesktop.layout.GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(label1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jPanel4Layout.createSequentialGroup()
                        .add(20, 20, 20)
                        .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel4Layout.createSequentialGroup()
                                .add(chartDrawTrackNameCB)
                                .add(61, 61, 61)
                                .add(jLabel7))
                            .add(topBorderCB)
                            .add(colorBordersCB)
                            .add(bottomBorderCB)
                            .add(labelYAxisCB))))
                .addContainerGap())
        );
        jPanel4Layout.setVerticalGroup(
            jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel4Layout.createSequentialGroup()
                .addContainerGap()
                .add(label1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(topBorderCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(bottomBorderCB)
                .add(7, 7, 7)
                .add(colorBordersCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel4Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabel7)
                    .add(chartDrawTrackNameCB))
                .add(32, 32, 32)
                .add(labelYAxisCB)
                .add(122, 122, 122))
        );

        chartPanel.add(jPanel4);
        jPanel4.setBounds(20, 30, 580, 330);

        tabbedPane.addTab("Charts", chartPanel);

        alignmentPanel.setLayout(null);

        jPanel1.setLayout(null);

        samMaxWindowSizeField.setText("jTextField1");
        samMaxWindowSizeField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxWindowSizeFieldActionPerformed(evt);
            }
        });
        samMaxWindowSizeField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxWindowSizeFieldFocusLost(evt);
            }
        });
        jPanel1.add(samMaxWindowSizeField);
        samMaxWindowSizeField.setBounds(220, 30, 84, 28);

        jLabel11.setText("Visibility range threshold (kb)");
        jPanel1.add(jLabel11);
        jLabel11.setBounds(20, 30, 186, 16);

        samShowDuplicatesCB.setText("Show duplicate reads");
        samShowDuplicatesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samShowDuplicatesCBActionPerformed(evt);
            }
        });
        jPanel1.add(samShowDuplicatesCB);
        samShowDuplicatesCB.setBounds(20, 190, 290, 23);

        jLabel12.setText("<html><i>Nominal window size at which alignments become visible");
        jPanel1.add(jLabel12);
        jLabel12.setBounds(320, 30, 363, 16);

        samFlagUnmappedPairCB.setText("Flag unmapped pairs");
        samFlagUnmappedPairCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samFlagUnmappedPairCBActionPerformed(evt);
            }
        });
        jPanel1.add(samFlagUnmappedPairCB);
        samFlagUnmappedPairCB.setBounds(20, 220, 310, 23);

        samShadeMismatchedBaseCB.setText("Shade mismatched bases by quality. ");
        samShadeMismatchedBaseCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samShadeMismatchedBaseCBActionPerformed(evt);
            }
        });
        jPanel1.add(samShadeMismatchedBaseCB);
        samShadeMismatchedBaseCB.setBounds(20, 310, 340, 23);

        jLabel13.setText("Maximum read depth");
        jPanel1.add(jLabel13);
        jLabel13.setBounds(20, 70, 133, 16);

        samMaxLevelField.setText("jTextField1");
        samMaxLevelField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxLevelFieldActionPerformed(evt);
            }
        });
        samMaxLevelField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxLevelFieldFocusLost(evt);
            }
        });
        jPanel1.add(samMaxLevelField);
        samMaxLevelField.setBounds(220, 70, 84, 28);

        jLabel14.setText("<html><i>Maximum number of rows of alignments to display.");
        jPanel1.add(jLabel14);
        jLabel14.setBounds(320, 70, 390, 30);

        jLabel15.setText("Mapping quality threshold:");
        jPanel1.add(jLabel15);
        jLabel15.setBounds(20, 110, 169, 16);

        mappingQualityThresholdField.setText("0");
        mappingQualityThresholdField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mappingQualityThresholdFieldActionPerformed(evt);
            }
        });
        mappingQualityThresholdField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                mappingQualityThresholdFieldFocusLost(evt);
            }
        });
        jPanel1.add(mappingQualityThresholdField);
        mappingQualityThresholdField.setBounds(220, 110, 70, 28);

        jLabel16.setText("<html><i>Reads with qualities  below the threshold are not shown.");
        jPanel1.add(jLabel16);
        jLabel16.setBounds(320, 110, 352, 16);

        jLabel17.setText("Insert size flagging threshold:");
        jPanel1.add(jLabel17);
        jLabel17.setBounds(20, 160, 200, 16);

        insertSizeThresholdField.setText("0");
        insertSizeThresholdField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                insertSizeThresholdFieldActionPerformed(evt);
            }
        });
        insertSizeThresholdField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                insertSizeThresholdFieldFocusLost(evt);
            }
        });
        jPanel1.add(insertSizeThresholdField);
        insertSizeThresholdField.setBounds(220, 160, 70, 28);

        jLabel18.setText("<html><i>Paired end alignments with insert sizes > this value are flagged.");
        jPanel1.add(jLabel18);
        jLabel18.setBounds(320, 160, 360, 40);

        jLabel10.setText("<html>Chromosome color legend &nbsp;&nbsp;&nbsp;<i>Used to flag paired end reads with mates on other chromosomes");
        jPanel1.add(jLabel10);
        jLabel10.setBounds(20, 370, 640, 30);

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 670, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 50, Short.MAX_VALUE)
        );

        jPanel1.add(jPanel2);
        jPanel2.setBounds(30, 410, 670, 50);

        autosortCB.setText("Order alignments at center line from left to right");
        autosortCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                autosortCBActionPerformed(evt);
            }
        });
        jPanel1.add(autosortCB);
        autosortCB.setBounds(20, 250, 450, 23);

        samMinBaseQualityField.setText("0");
        samMinBaseQualityField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMinBaseQualityFieldActionPerformed(evt);
            }
        });
        samMinBaseQualityField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMinBaseQualityFieldFocusLost(evt);
            }
        });
        jPanel1.add(samMinBaseQualityField);
        samMinBaseQualityField.setBounds(130, 340, 50, 28);

        jLabel19.setText("Min: ");
        jPanel1.add(jLabel19);
        jLabel19.setBounds(90, 340, 31, 16);

        jLabel20.setText("Max:");
        jPanel1.add(jLabel20);
        jLabel20.setBounds(200, 340, 30, 16);

        samMaxBaseQualityField.setText("0");
        samMaxBaseQualityField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                samMaxBaseQualityFieldActionPerformed(evt);
            }
        });
        samMaxBaseQualityField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                samMaxBaseQualityFieldFocusLost(evt);
            }
        });
        jPanel1.add(samMaxBaseQualityField);
        samMaxBaseQualityField.setBounds(240, 340, 50, 28);

        shadeCenteredAlignmentsCB.setText("Shade alignments intersecting center");
        shadeCenteredAlignmentsCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                shadeCenteredAlignmentsCBActionPerformed(evt);
            }
        });
        jPanel1.add(shadeCenteredAlignmentsCB);
        shadeCenteredAlignmentsCB.setBounds(20, 280, 450, 23);

        alignmentPanel.add(jPanel1);
        jPanel1.setBounds(20, 0, 740, 490);

        tabbedPane.addTab("Alignments", alignmentPanel);

        expressionPane.setLayout(null);

        probeMappingButtonGroup.add(expMapToGeneCB);
        expMapToGeneCB.setText("Map probes to genes");
        expMapToGeneCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                expMapToGeneCBActionPerformed(evt);
            }
        });

        jLabel24.setText("Expression probe mapping options: ");

        probeMappingButtonGroup.add(expMapToLociCB);
        expMapToLociCB.setText("<html>Map probes to target loci");
        expMapToLociCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                expMapToLociCBActionPerformed(evt);
            }
        });

        jLabel21.setText("<html><i>Note: Changes will not affect currently loaded datasets.");

        org.jdesktop.layout.GroupLayout jPanel8Layout = new org.jdesktop.layout.GroupLayout(jPanel8);
        jPanel8.setLayout(jPanel8Layout);
        jPanel8Layout.setHorizontalGroup(
            jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel8Layout.createSequentialGroup()
                .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel8Layout.createSequentialGroup()
                        .add(45, 45, 45)
                        .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(expMapToLociCB)
                            .add(expMapToGeneCB)))
                    .add(jPanel8Layout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jPanel8Layout.createSequentialGroup()
                                .add(24, 24, 24)
                                .add(jLabel21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 497, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                            .add(jLabel24))))
                .addContainerGap(179, Short.MAX_VALUE))
        );
        jPanel8Layout.setVerticalGroup(
            jPanel8Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel8Layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel24)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 44, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(expMapToLociCB)
                .add(14, 14, 14)
                .add(expMapToGeneCB)
                .addContainerGap(158, Short.MAX_VALUE))
        );

        expressionPane.add(jPanel8);
        jPanel8.setBounds(10, 30, 720, 310);

        tabbedPane.addTab("Probes", expressionPane);

        advancedPanel.setBorder(javax.swing.BorderFactory.createEmptyBorder(1, 10, 1, 10));
        advancedPanel.setLayout(null);

        jLabel1.setText("Genome Server URL");

        genomeServerURLTextField.setText("jTextField1");
        genomeServerURLTextField.setEnabled(false);
        genomeServerURLTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                genomeServerURLTextFieldActionPerformed(evt);
            }
        });
        genomeServerURLTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                genomeServerURLTextFieldFocusLost(evt);
            }
        });

        jLabel6.setText("Data Registry URL");

        dataServerURLTextField.setEnabled(false);
        dataServerURLTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                dataServerURLTextFieldActionPerformed(evt);
            }
        });
        dataServerURLTextField.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                dataServerURLTextFieldFocusLost(evt);
            }
        });

        editServerPropertiesCB.setText("Edit server properties");
        editServerPropertiesCB.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                editServerPropertiesCBActionPerformed(evt);
            }
        });

        clearGenomeCacheButton.setText("Clear Genome Cache");
        clearGenomeCacheButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearGenomeCacheButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel3Layout = new org.jdesktop.layout.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel3Layout.createSequentialGroup()
                        .add(29, 29, 29)
                        .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(jLabel1)
                            .add(jPanel3Layout.createSequentialGroup()
                                .add(jLabel6)
                                .add(44, 44, 44)
                                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                                    .add(dataServerURLTextField)
                                    .add(genomeServerURLTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 494, Short.MAX_VALUE)))))
                    .add(editServerPropertiesCB)
                    .add(clearGenomeCacheButton))
                .add(14, 14, 14))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel3Layout.createSequentialGroup()
                .add(84, 84, 84)
                .add(editServerPropertiesCB)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(jLabel1)
                    .add(genomeServerURLTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel3Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jLabel6)
                    .add(dataServerURLTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 68, Short.MAX_VALUE)
                .add(clearGenomeCacheButton)
                .addContainerGap())
        );

        advancedPanel.add(jPanel3);
        jPanel3.setBounds(10, 30, 710, 290);

        tabbedPane.addTab("Advanced", advancedPanel);

        getContentPane().add(tabbedPane, java.awt.BorderLayout.LINE_END);
        tabbedPane.getAccessibleContext().setAccessibleName("Advanced");

        okButton.setText("OK"); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        okCancelButtonPanel.add(okButton);

        cancelButton.setText("Cancel"); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        okCancelButtonPanel.add(cancelButton);

        getContentPane().add(okCancelButtonPanel, java.awt.BorderLayout.SOUTH);

        pack();
    }// </editor-fold>//GEN-END:initComponents
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        canceled = true;
        setVisible(false);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed

        if (inputValidated) {

            checkForProbeChanges();

            lastSelectedIndex = tabbedPane.getSelectedIndex();

            // Store the changed preferences
            preferenceManager.putAll(updatedPreferenceMap);

            // Clear the map that holds recents preference changes
            updatedPreferenceMap.clear();

            checkForSAMChanges();

            // Overlays
            if (updateOverlays) {
                TrackManager.getInstance().resetOverlayTracks();
            }
            IGVMainFrame.getInstance().repaint();
            setVisible(false);
        } else {
            resetValidation();
        }
    }//GEN-LAST:event_okButtonActionPerformed

    private void expMapToLociCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToLociCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(
                expMapToGeneCB.isSelected()));
}//GEN-LAST:event_expMapToLociCBActionPerformed

    private void clearGenomeCacheButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearGenomeCacheButtonActionPerformed
        GenomeManager.getInstance().clearGenomeCache();
        JOptionPane.showMessageDialog(this, "<html>Cached genomes have been removed.");
    }//GEN-LAST:event_clearGenomeCacheButtonActionPerformed

    private void editServerPropertiesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_editServerPropertiesCBActionPerformed
        boolean edit = editServerPropertiesCB.isSelected();
        dataServerURLTextField.setEnabled(edit);
        genomeServerURLTextField.setEnabled(edit);
    }//GEN-LAST:event_editServerPropertiesCBActionPerformed

    private void dataServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldFocusLost
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }//GEN-LAST:event_dataServerURLTextFieldFocusLost

    private void dataServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_dataServerURLTextFieldActionPerformed
        String attributeName = dataServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.DATA_SERVER_URL_KEY, attributeName);
    }//GEN-LAST:event_dataServerURLTextFieldActionPerformed

    private void genomeServerURLTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldFocusLost
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }//GEN-LAST:event_genomeServerURLTextFieldFocusLost

    private void genomeServerURLTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_genomeServerURLTextFieldActionPerformed
        String attributeName = genomeServerURLTextField.getText().trim();
        updatedPreferenceMap.put(PreferenceManager.GENOMES_SEQUENCE_URL, attributeName);
    }//GEN-LAST:event_genomeServerURLTextFieldActionPerformed

    private void insertSizeThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldFocusLost
        this.insertSizeThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_insertSizeThresholdFieldFocusLost

    private void insertSizeThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_insertSizeThresholdFieldActionPerformed
        String insertThreshold = insertSizeThresholdField.getText().trim();
        try {
            Integer.parseInt(insertThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.INSERT_SIZE_THRESHOLD,
                    insertThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Mapping quality threshold must be an integer.");
        }
    }//GEN-LAST:event_insertSizeThresholdFieldActionPerformed

    private void mappingQualityThresholdFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldFocusLost
        mappingQualityThresholdFieldActionPerformed(null);
    }//GEN-LAST:event_mappingQualityThresholdFieldFocusLost

    private void mappingQualityThresholdFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mappingQualityThresholdFieldActionPerformed
        String qualityThreshold = mappingQualityThresholdField.getText().trim();
        try {
            Integer.parseInt(qualityThreshold);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.QUALITY_THRESHOLD,
                    qualityThreshold);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Mapping quality threshold must be an integer.");
        }
    }//GEN-LAST:event_mappingQualityThresholdFieldActionPerformed

    private void samMaxLevelFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxLevelFieldFocusLost
        samMaxLevelFieldActionPerformed(null);
    }//GEN-LAST:event_samMaxLevelFieldFocusLost

    private void samMaxLevelFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxLevelFieldActionPerformed
        String maxLevelString = samMaxLevelField.getText().trim();
        try {
            Integer.parseInt(maxLevelString);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_LEVELS,
                    maxLevelString);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Maximum read depth must be an integer.");
        }
    }//GEN-LAST:event_samMaxLevelFieldActionPerformed

    private void samShadeMismatchedBaseCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShadeMismatchedBaseCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHADE_BASE_QUALITY,
                String.valueOf(samShadeMismatchedBaseCB.isSelected()));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());

}//GEN-LAST:event_samShadeMismatchedBaseCBActionPerformed

    private void samFlagUnmappedPairCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samFlagUnmappedPairCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.FLAG_UNMAPPED_PAIR,
                String.valueOf(samFlagUnmappedPairCB.isSelected()));
    }//GEN-LAST:event_samFlagUnmappedPairCBActionPerformed

    private void samShowDuplicatesCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samShowDuplicatesCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.SHOW_DUPLICATES,
                String.valueOf(samShowDuplicatesCB.isSelected()));
    }//GEN-LAST:event_samShowDuplicatesCBActionPerformed

    private void samMaxWindowSizeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxWindowSizeFieldFocusLost
        String maxSAMWindowSize = samMaxWindowSizeField.getText().trim();
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE,
                    maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Visibility range must be a number.");
        }
    }//GEN-LAST:event_samMaxWindowSizeFieldFocusLost

    private void samMaxWindowSizeFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxWindowSizeFieldActionPerformed
        String maxSAMWindowSize = String.valueOf(samMaxWindowSizeField.getText());
        try {
            Float.parseFloat(maxSAMWindowSize);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.MAX_VISIBLE_RANGE,
                    maxSAMWindowSize);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Visibility range must be a number.");
        }
    }//GEN-LAST:event_samMaxWindowSizeFieldActionPerformed

    private void chartDrawTrackNameCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chartDrawTrackNameCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_TRACK_NAME,
                String.valueOf(chartDrawTrackNameCB.isSelected()));
    }//GEN-LAST:event_chartDrawTrackNameCBActionPerformed

    private void colorBordersCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorBordersCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.COLOR_BORDERS,
                String.valueOf(colorBordersCB.isSelected()));
    }//GEN-LAST:event_colorBordersCBActionPerformed

    private void bottomBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bottomBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_BOTTOM_BORDER,
                String.valueOf(bottomBorderCB.isSelected()));
    }//GEN-LAST:event_bottomBorderCBActionPerformed

    private void topBorderCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_topBorderCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.ChartPreferences.DRAW_TOP_BORDER,
                String.valueOf(topBorderCB.isSelected()));
    }//GEN-LAST:event_topBorderCBActionPerformed

    private void chooseOverlayColorsButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chooseOverlayColorsButtonActionPerformed
        (new LegendDialog(IGVMainFrame.getInstance(), true)).setVisible(true);
    }//GEN-LAST:event_chooseOverlayColorsButtonActionPerformed

    private void colorOverlyCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_colorOverlyCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.COLOR_OVERLAY_KEY, String.valueOf(
                colorOverlyCB.isSelected()));
    }//GEN-LAST:event_colorOverlyCBActionPerformed

    private void displayTracksCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_displayTracksCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.DISPLAY_OVERLAY_TRACKS_KEY, String.valueOf(
                displayTracksCB.isSelected()));
        updateOverlays = true;
    }//GEN-LAST:event_displayTracksCBActionPerformed

    private void overlayTrackCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayTrackCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_TRACKS_KEY, String.valueOf(
                overlayTrackCB.isSelected()));
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());

        updateOverlays = true;
    }//GEN-LAST:event_overlayTrackCBActionPerformed

    private void overlayAttributeTextFieldKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldKeyTyped
        // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldKeyTyped

    private void overlayAttributeTextFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldFocusLost
        String attributeName = String.valueOf(overlayAttributeTextField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY,
                attributeName);
        updateOverlays = true;
    }//GEN-LAST:event_overlayAttributeTextFieldFocusLost

    private void overlayAttributeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_overlayAttributeTextFieldActionPerformed
        updatedPreferenceMap.put(PreferenceManager.OVERLAY_ATTRIBUTE_KEY, String.valueOf(
                overlayAttributeTextField.getText()));
        updateOverlays = true;
    // TODO add your handling code here:
    }//GEN-LAST:event_overlayAttributeTextFieldActionPerformed

    private void defaultTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldFocusLost

    private void defaultTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultTrackHeightFieldActionPerformed

    private void trackNameAttributeFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldFocusLost
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldFocusLost

    private void trackNameAttributeFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_trackNameAttributeFieldActionPerformed
        String attributeName = String.valueOf(trackNameAttributeField.getText());
        if (attributeName != null) {
            attributeName = attributeName.toUpperCase().trim();
        }
        updatedPreferenceMap.put(PreferenceManager.TRACK_ATTRIBUTE_NAME_KEY, attributeName);
    }//GEN-LAST:event_trackNameAttributeFieldActionPerformed

    private void defaultChartTrackHeightFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldFocusLost
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldFocusLost

    private void defaultChartTrackHeightFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_defaultChartTrackHeightFieldActionPerformed
        String defaultTrackHeight = String.valueOf(defaultChartTrackHeightField.getText());
        try {
            Integer.parseInt(defaultTrackHeight);
            updatedPreferenceMap.put(PreferenceManager.CHART_TRACK_HEIGHT_KEY, defaultTrackHeight);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Track height must be an integer number.");
        }
    }//GEN-LAST:event_defaultChartTrackHeightFieldActionPerformed

    private void showAttributesDisplayCheckBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showAttributesDisplayCheckBoxActionPerformed
        boolean state = ((JCheckBox) evt.getSource()).isSelected();
        updatedPreferenceMap.put(PreferenceManager.SHOW_ATTRIBUTE_VIEWS_KEY, String.valueOf(state));
        IGVMainFrame.getInstance().doShowAttributeDisplay(state);
    }//GEN-LAST:event_showAttributesDisplayCheckBoxActionPerformed

    private void joinSegmentsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_joinSegmentsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.JOIN_ADJACENT_SEGMENTS_KEY, String.valueOf(
                joinSegmentsCB.isSelected()));
    }//GEN-LAST:event_joinSegmentsCBActionPerformed

    private void combinePanelsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_combinePanelsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_SINGLE_TRACK_PANE_KEY, String.valueOf(
                combinePanelsCB.isSelected()));
    }//GEN-LAST:event_combinePanelsCBActionPerformed

    private void showMissingDataCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_showMissingDataCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SHOW_MISSING_DATA_KEY, String.valueOf(
                showMissingDataCB.isSelected()));
    }//GEN-LAST:event_showMissingDataCBActionPerformed

    private void autosortCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_autosortCBActionPerformed
        updatedPreferenceMap.put(
                PreferenceManager.SAMPreferences.AUTO_SORT,
                String.valueOf(autosortCB.isSelected()));

}//GEN-LAST:event_autosortCBActionPerformed

    private void samMinBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldActionPerformed
        String baseQuality = samMinBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MIN, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Base quality must be an integer.");
        }
}//GEN-LAST:event_samMinBaseQualityFieldActionPerformed

    private void samMinBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMinBaseQualityFieldFocusLost
        samMinBaseQualityFieldActionPerformed(null);
}//GEN-LAST:event_samMinBaseQualityFieldFocusLost

    private void samMaxBaseQualityFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldActionPerformed
        String baseQuality = samMaxBaseQualityField.getText().trim();
        try {
            Integer.parseInt(baseQuality);
            updatedPreferenceMap.put(PreferenceManager.SAMPreferences.BASE_QUALITY_MAX, baseQuality);
        } catch (NumberFormatException numberFormatException) {
            inputValidated = false;
            JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                    "Base quality must be an integer.");
        }

}//GEN-LAST:event_samMaxBaseQualityFieldActionPerformed

    private void samMaxBaseQualityFieldFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_samMaxBaseQualityFieldFocusLost
        samMaxBaseQualityFieldActionPerformed(null);
}//GEN-LAST:event_samMaxBaseQualityFieldFocusLost

    private void expMapToGeneCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_expMapToGeneCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.PROBE_MAPPING_KEY, String.valueOf(
                expMapToGeneCB.isSelected()));

    }//GEN-LAST:event_expMapToGeneCBActionPerformed

    private void labelYAxisCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_labelYAxisCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.ChartPreferences.Y_AXIS, String.valueOf(
                labelYAxisCB.isSelected()));
    }//GEN-LAST:event_labelYAxisCBActionPerformed

    private void shadeCenteredAlignmentsCBActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_shadeCenteredAlignmentsCBActionPerformed
        updatedPreferenceMap.put(PreferenceManager.SAMPreferences.SHADE_CENTER, String.valueOf(
                shadeCenteredAlignmentsCB.isSelected()));

}//GEN-LAST:event_shadeCenteredAlignmentsCBActionPerformed

    private void resetValidation() {
        // Assume valid input until proven otherwise
        inputValidated = true;
    }

    /*
     *    Object selection = geneMappingFile.getSelectedItem();
    String filename = (selection == null ? null : selection.toString().trim());
    updatedPreferenceMap.put(
    PreferenceManager.USER_PROBE_MAP_KEY,
    filename);
     * */
    private void initValues() {
        combinePanelsCB.setSelected(preferenceManager.getShowSingleTrackPane());
        //drawExonNumbersCB.setSelected(preferenceManager.getDrawExonNumbers());
        defaultChartTrackHeightField.setText(String.valueOf(
                preferenceManager.getDefaultChartTrackHeight()));
        defaultTrackHeightField.setText(String.valueOf(
                preferenceManager.getDefaultTrackHeight()));
        displayTracksCB.setSelected(preferenceManager.getDiplayOverlayTracks());
        overlayAttributeTextField.setText(preferenceManager.getOverlayAttribute());
        overlayTrackCB.setSelected(preferenceManager.getOverlayTracks());
        showMissingDataCB.setSelected(preferenceManager.getShowMissingData());
        joinSegmentsCB.setSelected(preferenceManager.isJoinAdjacentSegments());
        colorOverlyCB.setSelected(preferenceManager.getColorOverlay());
        overlayAttributeTextField.setEnabled(overlayTrackCB.isSelected());
        colorOverlyCB.setEnabled(overlayTrackCB.isSelected());
        chooseOverlayColorsButton.setEnabled(overlayTrackCB.isSelected());


        showAttributesDisplayCheckBox.setSelected(
                preferenceManager.getShowAttributeView());
        trackNameAttributeField.setText(preferenceManager.getTrackAttributeName());
        PreferenceManager prefManager = PreferenceManager.getInstance();
        genomeServerURLTextField.setText(prefManager.getGenomeListURL());
        dataServerURLTextField.setText(preferenceManager.getDataServerURL());

        // Chart panel
        PreferenceManager.ChartPreferences cp = prefManager.getChartPreferences();
        topBorderCB.setSelected(cp.isDrawTopBorder());
        bottomBorderCB.setSelected(cp.isDrawBottomBorder());
        colorBordersCB.setSelected(cp.isColorBorders());
        chartDrawTrackNameCB.setSelected(cp.isDrawTrackName());
        labelYAxisCB.setSelected(cp.isDrawAxis());

        PreferenceManager.SAMPreferences samPrefs = prefManager.getSAMPreferences();
        samMaxWindowSizeField.setText(String.valueOf(samPrefs.getMaxVisibleRange()));
        samMaxLevelField.setText(String.valueOf(samPrefs.getMaxLevels()));
        mappingQualityThresholdField.setText((String.valueOf(samPrefs.getQualityThreshold())));
        insertSizeThresholdField.setText((String.valueOf(samPrefs.getInsertSizeThreshold())));
        //samShowZeroQualityCB.setSelected(samPrefs.isShowZeroQuality());
        samShowDuplicatesCB.setSelected(samPrefs.isShowDuplicates());
        samFlagUnmappedPairCB.setSelected(samPrefs.isFlagUnmappedPair());
        autosortCB.setSelected(samPrefs.isAutosort());
        samShadeMismatchedBaseCB.setSelected(samPrefs.isShadeBaseQuality());
        samMinBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMin())));
        samMaxBaseQualityField.setText((String.valueOf(samPrefs.getBaseQualityMax())));
        samMinBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        samMaxBaseQualityField.setEnabled(samShadeMismatchedBaseCB.isSelected());
        shadeCenteredAlignmentsCB.setSelected(samPrefs.isShadeCenterFlag());
        initialSamMaxLevel = samPrefs.getMaxLevels();
        initialSamQualityThreshold = samPrefs.getQualityThreshold();
        initialShowDuplicates = samPrefs.isShowDuplicates();



        expMapToGeneCB.setSelected(preferenceManager.isMapProbesToGenes());
        expMapToLociCB.setSelected(!preferenceManager.isMapProbesToGenes());

    //chartColorTrackNameCB.setSelected(cp.isColorTrackName());
    //chartDrawYAxisCB.setSelected(cp.isDrawAxis());
    }

    private void checkForSAMChanges() {
        try {
            int maxLevel = Integer.parseInt(samMaxLevelField.getText());
            int qualThreshold = Integer.parseInt(mappingQualityThresholdField.getText());
            boolean showDoops = samShowDuplicatesCB.isSelected();
            if (maxLevel > initialSamMaxLevel || qualThreshold != initialSamQualityThreshold ||
                    showDoops != initialShowDuplicates) {
                LongRunningTask.submit(new Runnable() {

                    public void run() {
                        TrackManager.getInstance().reloadSAMTracks();
                        IGVMainFrame.getInstance().repaint();
                    }
                });

            }
        } catch (NumberFormatException numberFormatException) {
        }
    }

    private void checkForProbeChanges() {
        if (updatedPreferenceMap.containsKey(PreferenceManager.PROBE_MAPPING_KEY)) {
            ProbeToGeneMap.getInstance().clearProbeMappings();
        }
    }

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                PreferencesEditor dialog = new PreferencesEditor(new javax.swing.JFrame(), true);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {

                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
    //TODO move this to another class,  or resource bundle
    static String overlayText = "<html>These options control the treatment of mutation tracks.  " +
            "Mutation data may optionally<br>be overlayed on other tracks that have a matching attribute value " +
            "from the sample info <br>file. " +
            "This is normally an attribute that identifies a sample or patient. The attribute key <br>is specified in the" +
            "text field below.";

    public String getOverlayText() {
        return overlayText;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel advancedPanel;
    private javax.swing.JPanel alignmentPanel;
    private javax.swing.JCheckBox autosortCB;
    private javax.swing.JCheckBox bottomBorderCB;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox chartDrawTrackNameCB;
    private javax.swing.JPanel chartPanel;
    private com.jidesoft.swing.JideButton chooseOverlayColorsButton;
    private javax.swing.JButton clearGenomeCacheButton;
    private javax.swing.JCheckBox colorBordersCB;
    private javax.swing.JCheckBox colorOverlyCB;
    private javax.swing.JCheckBox combinePanelsCB;
    private javax.swing.JLabel comginePanelLabel;
    private javax.swing.JTextField dataServerURLTextField;
    private javax.swing.JTextField defaultChartTrackHeightField;
    private javax.swing.JTextField defaultTrackHeightField;
    private javax.swing.JCheckBox displayTracksCB;
    private javax.swing.JCheckBox editServerPropertiesCB;
    private javax.swing.JRadioButton expMapToGeneCB;
    private javax.swing.JRadioButton expMapToLociCB;
    private javax.swing.JPanel expressionPane;
    private javax.swing.ButtonGroup featureStyleButtonGroup;
    private javax.swing.JPanel generalPanel;
    private javax.swing.JTextField genomeServerURLTextField;
    private javax.swing.JTextField insertSizeThresholdField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JCheckBox joinSegmentsCB;
    private java.awt.Label label1;
    private javax.swing.JCheckBox labelYAxisCB;
    private javax.swing.JTextField mappingQualityThresholdField;
    private javax.swing.JLabel missingDataExplanation;
    private javax.swing.JLabel missingDataExplanation1;
    private javax.swing.JLabel missingDataExplanation2;
    private javax.swing.JLabel missingDataExplanation4;
    private javax.swing.JLabel missingDataExplanation5;
    private javax.swing.JLabel missingDataLabel;
    private javax.swing.JButton okButton;
    private com.jidesoft.dialog.ButtonPanel okCancelButtonPanel;
    private javax.swing.JTextField overlayAttributeTextField;
    private javax.swing.JCheckBox overlayTrackCB;
    private javax.swing.JPanel overlaysPanel;
    private javax.swing.ButtonGroup probeMappingButtonGroup;
    private javax.swing.ButtonGroup rnaiMapapingButtonGroup;
    private javax.swing.JCheckBox samFlagUnmappedPairCB;
    private javax.swing.JTextField samMaxBaseQualityField;
    private javax.swing.JTextField samMaxLevelField;
    private javax.swing.JTextField samMaxWindowSizeField;
    private javax.swing.JTextField samMinBaseQualityField;
    private javax.swing.JCheckBox samShadeMismatchedBaseCB;
    private javax.swing.JCheckBox samShowDuplicatesCB;
    private javax.swing.JCheckBox shadeCenteredAlignmentsCB;
    private javax.swing.JCheckBox showAttributesDisplayCheckBox;
    private javax.swing.JLabel showAttributesDisplayDescription;
    private javax.swing.JLabel showAttributesDisplayLabel;
    private javax.swing.JCheckBox showMissingDataCB;
    private javax.swing.JTabbedPane tabbedPane;
    private javax.swing.JCheckBox topBorderCB;
    private javax.swing.JTextField trackNameAttributeField;
    private javax.swing.JLabel trackNameAttributeLabel;
    private javax.swing.JPanel tracksPanel;
    // End of variables declaration//GEN-END:variables

    public boolean isCanceled() {
        return canceled;
    }
}
