/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/**
 *  Misc globally visible parameters.  These need a home.
 *
 */
package org.broad.igv.ui;

import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;

/**
 *  Placeholder for miscelleneous stuff that hasn't found a home yet.
 */
public class MiscStuff {

    private static Logger log = Logger.getLogger(MiscStuff.class);


    /**
     * Object representing the complete set of genes for the selected genomeId
     */
    //private static GeneManager geneData;
    /**
     * Special feature track.  Always present and always first in feature list.
     * Created when genomeId is loaded.
     */
    private static boolean showMissingData = false;

    static {
        String showMissingDataPref =
                PreferenceManager.getInstance().get(
                PreferenceManager.SHOW_MISSING_DATA_KEY, "false");

        if (showMissingDataPref != null && !showMissingDataPref.trim().equals("")) {
            showMissingData = Boolean.parseBoolean(showMissingDataPref);
        }
    }

    public static void setShowMissingDataEnabled(boolean value) {
        showMissingData = value;
    }

    public static boolean isShowMissingDataEnabled() {
        return showMissingData;
    }
    
    public Class getRendererByType(String type) {
        
        Class renderer = null;
            
        if(type.equals(type)) {
            
        }
        return renderer;
    }
}
