/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.ui;

import java.util.ArrayList;
import java.util.List;

/**
 * Class to hold a collection of messages for display to the user
 * 
 * @author jrobinso
 */
public class MessageCollection {

    String header;
    
    List<String> messages = new ArrayList();
    
    
    public void setHeader(String header) {
        this.header = header;
    }
    
    public String getHeader() {
        return header;
    }
    
    public void append(String message) {
        messages.add(message);
    }
    
    public void prepend(String message) {
        messages.add(0, message);
    }
    
    public List<String> getMessages() {
        return messages;
    }
    
    public boolean isEmpty() {
        return messages.isEmpty();
    }
    
    public String getFormattedMessage() {
        StringBuffer buffer = new StringBuffer(80 * messages.size());
        
        buffer.append("<html>");
        if(header != null) {
            buffer.append("<b>" + header + "</b><br>");
        }
        for(String msg : messages) {
            buffer.append(msg);
            buffer.append("<br>");
        }
        
        return buffer.toString();
    }
}
