/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.ui;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.broad.igv.ui.WaitCursorManager.CursorToken;

/**
 *
 * @author jrobinso
 */
public class LongRunningTask implements Callable {

    private static ExecutorService threadExecutor = Executors.newFixedThreadPool(3);
    private static ScheduledExecutorService schedule = Executors.newScheduledThreadPool(1);

    Runnable runnable;

    public static Future submit(Runnable runnable) {
        return threadExecutor.submit(new LongRunningTask(runnable));
    }

    public static Future schedule(Runnable runnable, long time) {
        return schedule.schedule(new LongRunningTask(runnable), time, TimeUnit.MILLISECONDS);
    }

    public LongRunningTask(Runnable runnable) {
        this.runnable = runnable;
    }

    public Object call() throws Exception {

        CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            runnable.run();
            return "";
        } finally {
            WaitCursorManager.removeWaitCursor(token);
        }

    }
}

