/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/



package org.broad.igv.ui;

//~--- JDK imports ------------------------------------------------------------

import javax.swing.SwingUtilities;


/**
 *
 * @author jrobinso
 */
public class GuiUtilities {

    /**
     * A wrapper around invokeOnEventThread.  If the runnable is already in the event dispatching 
     * queue it is just run.  Otherwise it is placed in the queue via invokeOnEventThread.
     * 
     * I'm not sure this is strictly neccessary,  but is safe.
     *
     * @param runnable
     */
    public static void invokeOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread())
        {
            runnable.run();
        }
        else
        {
            SwingUtilities.invokeLater(runnable);
        }

    }

}
