/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/

package org.broad.igv.ui;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JPanel;
import org.broad.igv.IGVConstants;
import org.broad.igv.ui.util.OkCancelDialog;


/**
*
* @author eflakes
*/
public class GenomeBuilderDialog extends OkCancelDialog  {
    
    private GenomeBuilderPane builderPane;
    private File genomeArchiveFile = null;
    
    public GenomeBuilderDialog(java.awt.Frame parent, boolean modal)  {
        
        super(parent, modal);
        builderPane = new GenomeBuilderPane();
        setTitle("Import Genome");
        
        // Get the area where our content can be displayed
        JPanel contentPane = getDialogPanel();
        contentPane.add(builderPane);
        pack();
        setResizable(false);    
        setLocationRelativeTo(parent);
        setOkButtonText(" Save ");
    }

    public String getCytobandFileName() {
        return builderPane.getCytobandFileName();
    }

    public String getFastaFileName() {
        return builderPane.getFastaFileName();
    }

    public String getGenomeId() {
        return builderPane.getGenomeId();
    }

    public String getGenomeDisplayName() {
        return builderPane.getGenomeDisplayName();
    }

    public String getRefFlatFileName() {
        return builderPane.getRefFlatFileName();
    }

    public String getGenomeArchiveLocation() {
        return builderPane.getGenomeArchiveLocation();
    }
    
    public String getArchiveFileName() {
        return builderPane.getArchiveFileName();
    }

    public String getSequenceLocation() {
        
        String name = getFastaFileName();
        if(name != null && !name.trim().equals("")) {
            
            if(genomeArchiveFile != null) {
                return "/"+genomeArchiveFile.getName()+"_seq/";
            }
            return "/"+getGenomeId()+"_seq/";
        }
        else {
            return null;
        }
    }

    @Override
    public boolean cancelButtonClicked(ActionEvent event) {
        return true;
    }

    @Override
    public boolean okButtonClicked(ActionEvent event) {
        
        boolean isOk = builderPane.validateSelection();
        
        // Passed validation now get genome location and check it
        if(isOk) {
            
            if(IGVConstants.IS_MAC) {
                genomeArchiveFile = builderPane.showGenomeArchiveDirectoryChooser();
            }
            else {
                genomeArchiveFile = builderPane.showGenomeArchiveDirectoryChooser();
            }
            if(genomeArchiveFile == null) {
                isOk = false;
            }
        }
        return isOk;
    }
}