/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.ui;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

/**
 *
 * @author eflakes
 */
public class FontManager {
    
    // Constants
    final public static String SCALABLE_FONT_NAME = "Lucida Sans";
    
    static public void applyScalableTextFont(Graphics2D graphics2) {
        
        Font font = getScalableFont(graphics2.getFont().getSize());
        //applyScalableTextHints(graphics2);
        graphics2.setFont(font);
    }
    
    static public void applyScalableTextFont(Graphics2D graphics2, int size) {
        
        Font font = getScalableFont(size);
        //applyScalableTextHints(graphics2);
        graphics2.setFont(font);
    }
    
    static public Font getScalableFont(int size) {
        return new Font(SCALABLE_FONT_NAME, Font.PLAIN, size);
    }
    
    static public Font getScalableFont(int attribute, int size) {
        return new Font(SCALABLE_FONT_NAME, attribute, size);
    }
    
    static public void applyScalableTextHints(Graphics2D graphics2) {
        
        graphics2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
        RenderingHints.VALUE_ANTIALIAS_ON);
    }
}
