/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;

import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

import com.jidesoft.dialog.ButtonPanel;
import com.jidesoft.dialog.StandardDialog;
import com.jidesoft.swing.JideScrollPane;
import javax.swing.JFrame;
import org.broad.igv.track.*;

public class AttributeGroupByDialog extends StandardDialog {

    // private JButton okButton = new JButton();
    private Map<String, JRadioButton> buttons;
    boolean cancelled = false;
    String groupByAttribute;
    
    public AttributeGroupByDialog(JFrame parent) {
        super(parent);
        setSize(500, 400);
    }

    public String getGroupByAttribute() {
        return groupByAttribute;
    }

    @Override
    public JComponent createBannerPanel() {
        return new JPanel();
    }

    @Override
    public JComponent createContentPanel() {
        JPanel contentPane = new JPanel();
        JideScrollPane scrollPane = new JideScrollPane(contentPane);

        contentPane.setLayout(new BoxLayout(contentPane, BoxLayout.Y_AXIS));
        buttons = new HashMap();

        // Group the radio buttons.
        ButtonGroup group = new ButtonGroup();

        JRadioButton none = new JRadioButton("None");
        group.add(none);
        none.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                groupByAttribute = null;
            }
        });
        contentPane.add(none);

        for (String attributeName : AttributeManager.getInstance().getAttributeKeys()) {
            JRadioButton button = new JRadioButton(attributeName);
            button.addActionListener(new ActionListener() {

                public void actionPerformed(ActionEvent e) {
                    if (((JRadioButton) e.getSource()).isSelected()) {
                        groupByAttribute = e.getActionCommand();
                    }
                }
            });
            buttons.put(attributeName, button);
            group.add(button);
            contentPane.add(button);
        }

        return scrollPane;
    }

    public boolean isCancelled() {
        return cancelled;
    }

    @Override
    public ButtonPanel createButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();

        JButton okButton = new JButton("OK");
        okButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                setVisible(false);
            }
        });

        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                cancelled = true;
                setVisible(false);
            }
        });

        buttonPanel.addButton(okButton, ButtonPanel.AFFIRMATIVE_BUTTON);
        buttonPanel.addButton(cancelButton, ButtonPanel.CANCEL_BUTTON);
        return buttonPanel;
    }

}
