/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * TrackSet.java
 *   A TrackSet is a collection of tracks that share a common location axis.
 */
package org.broad.igv.track;

import java.util.List;

/**
 *
 * @author jrobinso
 */
public class TrackSet {

    private String name;
    List<Track> dataTracks;
    int[] tileBoundaries;

    public TrackSet(List<Track> dataTracks) {
        this.dataTracks = dataTracks;
    }

    public List<Track> getTracks() {
        return dataTracks;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return dataTracks == null || dataTracks.isEmpty();
    }
}


