/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/




package org.broad.igv.track;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;


/**
 *  This class is based on the UCSC track configuration parameters
 *
 * @author jrobinso
 */
public class TrackProperties {

    /**
     * The track name.  Will be displayed to the left of the track.
     */
    private String name;

    /**
     * The track description.  The description, when supplied, will appear in popup text
     * when hovering over the track.  May optionally be displayed centered over the track
     * on certain chart types (currently scatter plot and barchart).
     */
    private String description;

    /**
     * A url to an web page associated with this track.  This is currently not used.
     */
    private String url;

    /**
     * The track height in pixels
     */
    private int height;

    private int minHeight;

    /**
     * The default color for the track.  This can be overridden by individual feature lines in
     * certain formats, notably BED.
     */
    private Color color;

    /**
     * An alternate color. The use of this color depends on the particular graph type (renderer)
     * being displayed.  See documentation for specific renderes for details.
     */
    private Color altColor;
    
    private Color midColor;

    private String genome;

    private int offset;
    
    private boolean autoScaleFlag = false;

    private float minValue = Float.NaN;

    private float maxValue = Float.NaN;
    
    private float midValue = 0.0f;
    
    private boolean drawMidValue = true;

    private Class rendererClass;

    private WindowFunction windowingFunction;

    private int smoothingWindow;

    /**
     * Method description
     *
     *
     * @return
     */
    public int getOffset() {
        return offset;
    }

    /**
     * Method description
     *
     *
     * @param offset
     */
    public void setOffset(int offset) {
        this.offset = offset;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getName() {
        return name;
    }

    /**
     * Method description
     *
     *
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getDescription() {
        return description;
    }

    /**
     * Method description
     *
     *
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getUrl() {
        return url;
    }

    /**
     * Method description
     *
     *
     * @param url
     */
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getHeight() {
        return height;
    }

    /**
     * Method description
     *
     *
     * @param height
     */
    public void setHeight(int height) {
        this.height = height;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getColor() {
        return color;
    }

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setColor(Color color) {
        this.color = color;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getAltColor() {
        return altColor;
    }

    /**
     * Method description
     *
     *
     * @param altColor
     */
    public void setAltColor(Color altColor) {
        this.altColor = altColor;
    }

    /**
     * Autoscale if either (1) autoscale is explictly set on,  or (2) view limits are not provided
     */
    public boolean isAutoScale() {
        return autoScaleFlag || Float.isNaN(minValue) || Float.isNaN(maxValue);
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public String getGenome() {
        return genome;
    }

    /**
     * Method description
     *
     *
     * @param genome
     */
    public void setGenome(String genome) {
        this.genome = genome;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getMinValue() {
        return minValue;
    }

    /**
     * Method description
     *
     *
     * @param minValue
     */
    public void setMinValue(float minValue) {
        this.minValue = minValue;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getMaxValue() {
        return maxValue;
    }

    /**
     * Method description
     *
     *
     * @param maxValue
     */
    public void setMaxValue(float maxValue) {
        this.maxValue = maxValue;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public WindowFunction getWindowingFunction() {
        return windowingFunction;
    }

    /**
     * Method description
     *
     *
     * @param windowingFunction
     */
    public void setWindowingFunction(WindowFunction windowingFunction) {
        this.windowingFunction = windowingFunction;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getSmoothingWindow() {
        return smoothingWindow;
    }

    /**
     * Method description
     *
     *
     * @param smoothingWindow
     */
    public void setSmoothingWindow(int smoothingWindow) {
        this.smoothingWindow = smoothingWindow;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Class getRendererClass() {
        return rendererClass;
    }

    /**
     * Method description
     *
     *
     * @param rendererClass
     */
    public void setRendererClass(Class rendererClass) {
        this.rendererClass = rendererClass;
    }

    public void setAutoScale(

    boolean autoScale) {
        this.autoScaleFlag = autoScale;
    }

    public float getMidValue() {
        return midValue;
    }

    public void setMidValue(float midValue) {
        this.midValue = midValue;
    }

    public Color getMidColor() {
        return midColor;
    }

    public void setMidColor(Color midColor) {
        this.midColor = midColor;
    }

    public

    boolean isDrawMidValue() {
        return drawMidValue;
    }

    public void setDrawMidValue(boolean drawMidValue) {
        this.drawMidValue = drawMidValue;
    }

    /**
     * @return the minHeight
     */
    public int getMinHeight() {
        return minHeight;
    }

    /**
     * @param minHeight the minHeight to set
     */
    public void setMinHeight(int minHeight) {
        this.minHeight = minHeight;
    }

}
