/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.track;

//~--- non-JDK imports --------------------------------------------------------
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import org.broad.igv.renderer.ContinuousColorScale;

/**
 *
 * @author jrobinso
 */
public interface Track {

    /**
     * Render the track contects in the rectangle
     *
     *
     * @param context
     * @param rect
     */
    public void render(RenderContext context, Rectangle rect);

    /**
     * Render track borders in the rectangle
     *
     *
     * @param context
     * @param rect
     */
    public void renderBorder(RenderContext context, Rectangle rect);

    /**
     * Render the track border
     *
     *
     * @param context
     * @param rect
     */
    public void renderAxis(RenderContext context, Rectangle rect);

    public void renderName(Graphics2D graphics, Rectangle rect, Rectangle visibleRect);

    /**
     * Render this track as an overlay in the track rectangle
     *
     *
     * @param context
     * @param rect
     */
    public void overlay(RenderContext context, Rectangle rect);

    /**
     * Method description
     *
     *
     * @return
     */
    public String getId();

    public void setDisplayName(String name);

    /**
     * Method description
     *
     *
     * @return
     */
    public String getDisplayName();

    public String getActualDisplayName();

    /**
     * Method description
     *
     *
     * @return
     */
    public ResourceLocator getDataResourceLocator();

    /**
     * Method description
     *
     *
     * @param key
     * @param value
     */
    public void setAttributeValue(String key, String value);

    /**
     * Method description
     *
     *
     * @param attributeKey
     *
     * @return
     */
    public String getAttributeValue(String attributeKey);

    /**
     * Method description
     *
     *
     * @param isVisible
     */
    public void setVisible(boolean isVisible);

    /**
     * An inactive track should be treated as though it does not exist
     * @return
     */
    public boolean isVisible();

    /**
     * Set whether the track is visible or not if 
     * @param overlayVisible
     */
    public void setOverlayVisible(boolean overlayVisible);

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setTrackType(TrackType type);

    /**
     * Method description
     *
     *
     * @return
     */
    public TrackType getTrackType();

    /**
     * Method description
     *
     *
     * @param preferredHeight
     */
    public void setHeight(int preferredHeight);

    public void setTop(int top);

    public int getTop();

    public ContinuousColorScale getColorScale();

    /**
     * Method description
     *
     *
     * @return
     */
    public int getHeight();

    public int getPreferredHeight();

    /**
     * Method description
     *
     *
     * @param axisDefinition
     */
    public void setDataRange(DataRange axisDefinition);

    /**
     * Method description
     *
     *
     * @return
     */
    public DataRange getAxisDefinition();

    /**
     * Return the color of this track, which might be the default
     *
     * @return
     */
    public Color getColor();

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setColor(Color color);

    /**
     * Return the color of this track, which might be the default
     *
     * @return
     */
    public Color getAltColor();

    public void setAltColor(Color color);

    public Color getMidColor();

    public void setMidColor(Color color);

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setStatType(WindowFunction type);

    /**
     * Method description
     *
     *
     * @return
     */
    public WindowFunction getWindowFunction();

    /**
     * Method description
     *
     *
     * @param rc
     */
    public void setRendererClass(Class rc);

    /**
     * Method description
     *
     *
     * @return
     */
    public Renderer getRenderer();

    public void updateProperties();

    /**
     * Method description
     *
     *
     * @param selected
     */
    public void setSelected(boolean selected);

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isSelected();

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isDraggable();

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogNormalized();

    // public List<Feature> getFeatures(String chr, int startLocation, int endLocation);

    // public int getNumberOfFeatureLevels();

    // public List<LocusScore> getSummaryScores(String chr, int startLocation, int endLocation, int zoom);
    /**
     * Method description
     *
     *
     * @param chr
     * @param position
     * @param y
     *
     * @return
     */
    public String getValueStringAt(String chr, double position, int y);

    /**
     * Method description
     *
     *
     * @param chr
     * @param start
     * @param end
     * @param zoom
     * @param type
     *
     * @return
     */
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type);

    /**
     * Enable/Disables the track for feature that can be shown at
     * different levels with in a track.
     *
     * @param timestamp
     */

    // public void setMultiLevelFeatures(boolean isMultiLevel);

    // public boolean isMuliLevelFeatures();
    public void refreshData(long timestamp);

    /**
     * Record the file from which this track was created.
     * @param filename
     */
    public void setSourceFile(String filename);

    /**
     * Return the filename from which this track was created.
     * @return
     */
    public String getSourceFile();

    /**
     *
     * @param value
     */
    public void setExpanded(boolean value);

    /**
     * @return
     */
    public boolean isExpanded();

    /**
     * Method description
     *
     *
     * @param x
     * @param y
     */
    public boolean handleClick(MouseEvent e);

    public Collection<WindowFunction> getAvailableWindowFunctions();

    public void setTrackProperties(TrackProperties trackProperties);

    /**
     * Called to force track to preload data prior to a repaint.
     * @param chr
     * @param start
     * @param end
     */
    public void preloadData(String chr, int start, int end, int zoom);
}
