/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/



package org.broad.igv.track;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.SequenceRenderer;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Rectangle;


/**
 *
 * @author jrobinso
 */
public class SequenceTrack extends AbstractTrack {

    /** Field description */
    public static final int SEQUENCE_HEIGHT = 14;

    SequenceRenderer sequenceRenderer = new SequenceRenderer();
    ColorScale colorScale;

    /**
     * Constructs ...
     *
     *
     * @param name
     */
    public SequenceTrack(String name) {
        super(null, name);
    }

    /**
     * Method description
     *
     *
     * @param context
     * @param rect
     */
    public void render(RenderContext context, Rectangle rect) {

        // Are we zoomed in far enough to show the sequence?  Scale is
        // in BP / pixel,  need at least 1 pixel.
        if (context.getScale() < 1)
        {
            sequenceRenderer.draw(context, rect);
        }

    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setStatType(WindowFunction type) {

        // ignore
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public WindowFunction getWindowFunction() {

        // ignore
        return null;
    }

    /**
     * Method description
     *
     *
     * @param rc
     */
    public void setRendererClass(Class rc) {

        // ignored
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Renderer getRenderer() {
        return sequenceRenderer;
    }

    /**
     * // TODO -- this reference to the view context is ugly. Is there some other way to
     * // do this?
     * @return
     */
    @Override
    public int getHeight() {

        // boolean showSequence = IGVModel.getInstance().getViewContext().getScale()  < 1;
        // return showSequence ? SEQUENCE_HEIGHT : 0;
        return SEQUENCE_HEIGHT;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogNormalized() {
        return true;
    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param position
     * @param y
     *
     * @return
     */
    public String getValueStringAt(String chr, double position, int y) {

        // TOTO -- return sequence at this position
        return "";
    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param start
     * @param end
     * @param zoom
     * @param type
     *
     * @return
     */
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        return 0;
    }

    /**
     * Method description
     *
     *
     * @param x
     * @param y
     */
    public boolean handleClick(int x, int y) {

        // Ignore
        return false;
    }

}
