/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class RenderContext {

    private String chr;
    private double startLocation;
    private double endLocation;
    private int zoom;
    private double originShift;
    private double scale;
    private Graphics2D graphics;
    private Map<Color, Graphics2D> graphicCacheByColor;
    Rectangle visibleRect;

    public RenderContext(String chr, double startLocation, double endLocation,
            int zoom, double originShift, double scale, Rectangle visibleRect,
            Graphics2D graphics) {
        this.chr = chr;
        this.startLocation = startLocation;
        this.endLocation = endLocation;
        this.originShift = originShift;
        this.zoom = zoom;
        this.scale = scale;
        this.graphics = graphics;
        this.visibleRect = visibleRect;
        this.graphicCacheByColor = new HashMap();
    }

    public Graphics2D getGraphic2DForColor(Color color) {

        Graphics2D g = graphicCacheByColor.get(color);
        if (g == null) {
            g = (Graphics2D) graphics.create();
            graphicCacheByColor.put(color, g);
            g.setColor(color);
        }
        return g;
    }

    public String getChr() {
        return chr;
    }

    public double getStartLocation() {
        return startLocation;
    }

    public double getEndLocation() {
        return endLocation;
    }

    public double getOrigin() {
        return originShift;
    }

    public double getScale() {
        return scale;
    }

    public Rectangle getVisibleRect() {
        return visibleRect;
    }

    

    public Graphics2D getGraphics() {
        return graphics;
    }

    public int getZoom() {
        return zoom;
    }
    
    /**
     * Release graphics objects
     * @throws java.lang.Throwable
     */
    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        for(Graphics2D g : graphicCacheByColor.values()) {
            g.dispose();
        }
    }

    
    
}
