/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.track;

//~--- non-JDK imports --------------------------------------------------------
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.Renderer;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import org.broad.igv.feature.Feature;

/**
 *
 * @author jrobinso
 */
public class GeneTrack implements Track {

    SequenceTrack sequenceTrack;
    FeatureTrack featureTrack;

    /**
     * Constructs ...
     *
     *
     * @param featureTrack
     * @param sequenceTrack
     */
    public GeneTrack(FeatureTrack featureTrack, SequenceTrack sequenceTrack) {
        this.featureTrack = featureTrack;
        this.sequenceTrack = sequenceTrack;
    }

    /**
     * Method description
     *
     *
     * @param context
     * @param rect
     */
    public void render(RenderContext context, Rectangle rect) {

        // Split rects
        int seqHeight = sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            sequenceTrack.render(context, seqRect);
        }

        rect.y += seqHeight;
        rect.height -= seqHeight;
        featureTrack.render(context, rect);
    }

    /**
     * Method description
     *
     *
     * @param context
     * @param rect
     */
    public void renderBorder(RenderContext context, Rectangle rect) {

        // Split rects
        int seqHeight = sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            sequenceTrack.renderBorder(context, seqRect);
        }

        rect.y += seqHeight;
        rect.height -= seqHeight;
        featureTrack.renderBorder(context, rect);
    }

    /**
     * Method description
     *
     *
     * @param context
     * @param rect
     */
    public void renderAxis(RenderContext context, Rectangle rect) {

        // Split rects
        int seqHeight = sequenceTrack.getHeight();
        if (seqHeight > 0) {
            Rectangle seqRect = new Rectangle(rect);
            seqRect.height = seqHeight;
            sequenceTrack.renderAxis(context, seqRect);
        }

        rect.y += seqHeight;
        rect.height -= seqHeight;
        featureTrack.renderAxis(context, rect);
    }

    /**
     * Method description
     *
     *
     * @param context
     * @param rect
     */
    public void overlay(RenderContext context, Rectangle rect) {
        featureTrack.render(context, rect);
        sequenceTrack.render(context, rect);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getId() {
        return featureTrack.getId();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getDisplayName() {
        return featureTrack.getDisplayName();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public ResourceLocator getDataResourceLocator() {
        return featureTrack.getDataResourceLocator();
    }

    /**
     * Method description
     *
     *
     * @param key
     * @param value
     */
    public void setAttributeValue(String key, String value) {
        featureTrack.setAttributeValue(key, value);
    }

    /**
     * Method description
     *
     *
     * @param attributeKey
     *
     * @return
     */
    public String getAttributeValue(String attributeKey) {
        return featureTrack.getAttributeValue(attributeKey);
    }

    /**
     * Method description
     *
     *
     * @param isVisible
     */
    public void setVisible(boolean isVisible) {
        featureTrack.setVisible(isVisible);
        sequenceTrack.setVisible(isVisible);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isVisible() {
        return featureTrack.isVisible() || sequenceTrack.isVisible();
    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setTrackType(TrackType type) {
        featureTrack.setTrackType(type);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public TrackType getTrackType() {
        return featureTrack.getTrackType();
    }

    /**
     * Method description
     *
     *
     * @param preferredHeight
     */
    public void setHeight(int preferredHeight) {
        featureTrack.setHeight(preferredHeight - sequenceTrack.getHeight());
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getHeight() {
        return featureTrack.getHeight() + sequenceTrack.getHeight();
    }

    /**
     * Method description
     *
     *
     * @param axisDefinition
     */
    public void setDataRange(DataRange axisDefinition) {
        featureTrack.setDataRange(axisDefinition);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public DataRange getAxisDefinition() {
        return featureTrack.getAxisDefinition();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getColor() {
        return featureTrack.getColor();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getAltColor() {
        return featureTrack.getAltColor();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getMidColor() {
        return featureTrack.getMidColor();
    }

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setColor(Color color) {
        featureTrack.setColor(color);
    }

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setAltColor(Color color) {
        featureTrack.setAltColor(color);
    }

    /**
     * Method description
     *
     *
     * @param color
     */
    public void setMidColor(Color color) {
        featureTrack.setMidColor(color);
    }

    /**
     * Method description
     *
     *
     * @param type
     */
    public void setStatType(WindowFunction type) {
        featureTrack.setStatType(type);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public WindowFunction getWindowFunction() {
        return featureTrack.getWindowFunction();
    }

    /**
     * Method description
     *
     *
     * @param rc
     */
    public void setRendererClass(Class rc) {
        featureTrack.setRendererClass(rc);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Renderer getRenderer() {
        return featureTrack.getRenderer();
    }

    /**
     * Method description
     *
     *
     * @param selected
     */
    public void setSelected(boolean selected) {
        featureTrack.setSelected(selected);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isSelected() {
        return featureTrack.isSelected();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isDraggable() {
        return featureTrack.isDraggable();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isLogNormalized() {
        return featureTrack.isLogNormalized();
    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param position
     * @param y
     *
     * @return
     */
    public String getValueStringAt(String chr, double position, int y) {

        // TODO -- pass to seqeucne or feature track depending on y
        return featureTrack.getValueStringAt(chr, position, y);
    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param start
     * @param end
     * @param zoom
     * @param type
     *
     * @return
     */
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type) {
        return featureTrack.getRegionScore(chr, start, end, zoom, type);
    }

    /**
     * Method description
     *
     *
     * @param timestamp
     */
    public void refreshData(long timestamp) {
        featureTrack.refreshData(timestamp);
    }

    /**
     * Method description
     *
     *
     * @param filename
     */
    public void setSourceFile(String filename) {
        featureTrack.setSourceFile(filename);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getSourceFile() {
        return featureTrack.getSourceFile();
    }

    /**
     *
     * @param value
     */
    public void setExpanded(boolean value) {
        featureTrack.setExpanded(value);
    }

    /**
     * @return
     */
    public boolean isExpanded() {
        return featureTrack.isExpanded();
    }

    /**
     * Method description
     *
     *
     * @param x
     * @param y
     *
     * @return
     */
    public boolean handleClick(MouseEvent e) {
        return featureTrack.handleClick(e);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return featureTrack.getAvailableWindowFunctions();
    }

    /**
     * Method description
     *
     *
     * @param trackProperties
     */
    public void setTrackProperties(TrackProperties trackProperties) {
        featureTrack.setTrackProperties(trackProperties);
    }

    /**
     * Method description
     *
     *
     * @param overlayVisible
     */
    public void setOverlayVisible(boolean overlayVisible) {
        featureTrack.setOverlayVisible(overlayVisible);
    }

    /**
     * Method description
     *
     *
     * @param name
     */
    public void setDisplayName(String name) {
        featureTrack.setDisplayName(name);
    }

    /**
     * Method description
     *
     */
    public void updateProperties() {
        featureTrack.updateProperties();
    }

    public void preloadData(String chr, int start, int end, int zoom) {
        featureTrack.preloadData(chr, start, end, zoom);
    }

    public void renderName(Graphics2D graphics, Rectangle rect, Rectangle visibleRect) {
        featureTrack.renderName(graphics, rect, visibleRect);
    }

    public int getPreferredHeight() {
        return getHeight();
    }

    public void setTop(int top) {
        featureTrack.setTop(top);
    }

    public int getTop() {
        return featureTrack.getTop();
    }

    public String getActualDisplayName() {
        return featureTrack.getActualDisplayName();
    }
    
    public ContinuousColorScale getColorScale() {
        return featureTrack.getColorScale();
    }

    public List<Feature> getFeatures(String chr) {
        return featureTrack.getFeatures(chr);
    }
}
