/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.track;

//~--- non-JDK imports --------------------------------------------------------
import org.apache.log4j.Logger;


import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureUtils;
import org.broad.igv.util.ResourceLocator;

import java.awt.Color;


import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author jrobinso
 */
public class FeatureTrack extends AbstractFeatureTrack {

    private static Logger log = Logger.getLogger(DataTrack.class);
    /**
     * Map of chromosome -> feature list
     */
    private Map<String, List<Feature>> featureMap;

    /**
     * NOTE:  Ths constructor apparently assumes feature lists are already sorted.
     *
     *
     * @param locator
     * @param name
     * @param features
     */
    public FeatureTrack(ResourceLocator locator, String name) {
        super(locator, name);
        setMinimumHeight(10);
        setColor(Color.blue.darker());
    }

        /**
     * NOTE:  Ths constructor apparently assumes feature lists are already sorted.
     *
     *
     * @param locator
     * @param name
     * @param features
     */
    public FeatureTrack(ResourceLocator locator, String name, List<Feature> allFeatures) {
        super(locator, name);
        initFeatures(allFeatures);
        setMinimumHeight(10);
        setColor(Color.blue.darker());
    }

    /**
     * NOTE:  Ths constructor apparently assumes feature lists are already sorted.
     *
     *
     * @param locator
     * @param name
     * @param features
     */
    public FeatureTrack(ResourceLocator locator, String name, Map<String, List<Feature>> features) {
        super(locator, name);
        setMinimumHeight(10);
        setColor(Color.blue.darker());
        this.featureMap = features;
        sampleGenomeFeatures();
    }



    public void initFeatures(List<Feature> allFeatures) {
        // Separate features by chromosome

        featureMap = new HashMap();
        for (Feature f : allFeatures)
        {
            List<Feature> fList = getFeatures(f.getChromosome());
            if (fList == null)
            {
                fList = new ArrayList();
                featureMap.put(f.getChromosome(), fList);
            }
            fList.add(f);
        }

        for (List<Feature> featureList : featureMap.values())
        {
            FeatureUtils.sortFeatureList(featureList);
        }
        sampleGenomeFeatures();


    }

    public void setFeatures(String chr, List<Feature> features) {
        setFeatures(chr, features, false);
    }

    /**
     * Method description
     *
     *
     * @param chr
     * @param features
     */
    public void setFeatures(String chr, List<Feature> features, boolean sorted) {
        if (!sorted)
        {
            FeatureUtils.sortFeatureList(features);
        }
        resetLevelList();
        featureMap.put(chr, features);
    }

    public List<Feature> getFeatures(String chr) {
        return featureMap.get(chr);
    }
}
