/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.track;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.ParsingUtils;
import org.broad.igv.util.AsciiLineReader;
import org.broad.igv.util.ObjectCache;
import org.broad.igv.util.ResourceLocator;

/**
 *
 * @author jrobinso
 */
public class FeatureDirTrack extends AbstractFeatureTrack {

    static Logger log = Logger.getLogger(FeatureDirTrack.class);
    ObjectCache<String, List<Feature>> featureCache;
    List<Feature> wholeGenomeFeatures = new ArrayList();
    Properties fileMap;
    File rootDir;
    ResourceLocator rootLocator;

    public FeatureDirTrack(ResourceLocator locator, String name) throws IOException {
        super(locator, name);
        featureCache = new ObjectCache(3);
        rootLocator = locator;
        rootDir = (new File(locator.getPath())).getParentFile();

        fileMap = new Properties();
        InputStream propStream = ParsingUtils.openInputStream(locator);
        fileMap.load(propStream);
        propStream.close();


    }

    @Override
    public List<Feature> getFeatures(String chr) {
        List<Feature> features = featureCache.get(chr);
        if (features == null)
        {
            String filename = fileMap.getProperty(chr);
            if (filename != null)
            {
                AsciiLineReader reader = null;
                try
                {
                    File featureFile = new File(rootDir, filename);
                    // Load features here
                    ResourceLocator loc = new ResourceLocator(rootLocator.getServerURL(), featureFile.getAbsolutePath());

                    FeatureParser fp = AbstractFeatureParser.getInstanceFor(filename);
                    reader = ParsingUtils.openAsciiReader(loc);
                    features = fp.loadFeatures(reader);
                    featureCache.put(chr, features);
                    reader.close();
                } catch (IOException ex)
                {
                    log.info("Error loading feature file: " + filename, ex);
                } finally
                {
                    if (reader != null)
                    {
                        reader.close();
                    }
                }



            }

        }
        return features;
    }

    @Override
    public void setFeatures(String chr, List<Feature> features) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

