package org.broad.igv.tools.sort;

import org.apache.log4j.Logger;
import org.broad.igv.sam.DotAlignedAlignment;

import java.io.*;

import net.sf.samtools.util.SortingCollection;

/**
 * Created by IntelliJ IDEA.
 * User: nazaire
 * Date: Jun 2, 2009
 */
public class SortableRecordCodec implements SortingCollection.Codec<SortableRecord>  
{
    private static Logger log = Logger.getLogger(SortableRecordCodec.class);
    DataOutputStream outputStream;
    DataInputStream inputStream;

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = new DataOutputStream(outputStream);
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = new DataInputStream(inputStream);
    }

    public void encode(SortableRecord alignment)
    {
        try {
            outputStream.writeUTF(alignment.getChromosome());
            outputStream.writeInt(alignment.getStart());
            outputStream.writeUTF(alignment.getText());
        } catch (IOException ex) {
            log.error("Error encoding alignment", ex);
        }
    }

    public SortableRecord decode() {
        try {

            String chr = inputStream.readUTF();
            int start = inputStream.readInt();
            String text = inputStream.readUTF();
            return new SortableRecord(chr, start, text);
        } catch (EOFException ex) {
            return null;
        } catch (IOException ex) {
            log.error("Error decoding alignment", ex);
            return null;
        }
    }

    public SortingCollection.Codec<SortableRecord> clone() {
        SortableRecordCodec other = new SortableRecordCodec();
        return other;
    }
}
