package org.broad.igv.tools.sort;

import org.broad.igv.feature.ParsingUtils;
import net.sf.samtools.util.AsciiLineReader;

/**
 * @author: nazaire
 */

public class Parser
{
    private static final int CHROMOSOME_COLUMN = 1;
    private static final int START_COLUMN = 2;
    private String[] fields = new String[START_COLUMN + 1];


    public SortableRecord readNextRecord(AsciiLineReader reader)
    {
        String nextLine = reader.readLine();
        if (nextLine == null)
        {
            return null;
        }
        
        return createRecord(nextLine);
    }

    private SortableRecord createRecord(String nextLine)
    {
        int nTokens = ParsingUtils.split(nextLine, fields, '\t');
        // TODO -- what to do if nTokens < 4?

        String chr = fields[CHROMOSOME_COLUMN];
        int start = Integer.parseInt(fields[START_COLUMN].trim());
        String text = nextLine;

        return new SortableRecord(chr, start, text);
    }
}
