/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.preprocess.DataConsumer;
import org.broad.igv.preprocess.WiggleParser;

/**
 * "Samples" a directory of wig files to produce a "whole chromosome" wig file.
 *
 * @author jrobinso
 */
public class WigSampler implements DataConsumer {

    Genome genome;
    int sampleInterval = 100000;
    float sum = 0;
    int n = 0;
    PrintWriter out;
    int startPosition = 0;

    public WigSampler() {
    }

    public void process(String genomeId, List<File> inputFiles, PrintWriter out) {
        GenomeManager.getInstance().findGenomeAndLoad(genomeId);
        genome = GenomeManager.getInstance().getGenome(genomeId);
        this.out = out;

        out.println("track wiggle_0");

        for (File f : inputFiles) {
            WiggleParser parser = new WiggleParser(f.getAbsolutePath());
            parser.setDataConsumer(this);
            parser.parse();
        }
    }

    public void addData(String chr, int start, int end, float data) {
        n++;
        sum += data;

        if (n % sampleInterval == 0) {
            // Genome position in kb.
            float mean = sum / n;

            int position = (startPosition + end) / 2;
            
            out.println(chr + "\t" + position + "\t" + (position + 1) + "\t" +
                    mean);

            startPosition = end;
            n = 0;
            sum = 0;
        }
    }

    public void newChromosome(String chr) {
        n = 0;
        sum = 0;
        startPosition = 0;
    }

    public void parsingComplete() {
        // sort
        // write out
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("Usage: java WigSampler <input directory> " + "<list file name> <genome id>");
            System.exit(-1);
        }

        File inputDir = new File(args[0]);
        File listFile = new File(inputDir, args[1]);
        File outputFile = new File(inputDir, "chrAll.wig");
        String genomeId = args[2];

        System.out.println("list file = " + listFile.getAbsolutePath());

        BufferedReader reader = null;
        PrintWriter out = null;
        List<File> inputFiles = new ArrayList();
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
            reader = new BufferedReader(new FileReader(listFile));
            String nextLine;
            while ((nextLine = reader.readLine()) != null) {
                String path = nextLine.trim();
                File f = new File(path);
                inputFiles.add(f);
            }
            (new WigSampler()).process(genomeId, inputFiles, out);

        } catch (IOException ex) {
            System.err.println("Error parsing sam file group file");
            ex.printStackTrace();

        } finally {
            out.close();
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException ex) {
                }
            }
        }


    }
}
