/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.tools;

import java.io.File;
import org.broad.igv.data.SegmentedDataWriter;
import org.broad.igv.preprocess.old.IGVPreprocessor;
import org.broad.igv.sam.reader.AlignmentIndexer;

/**
 *
 * @author jrobinso
 */
public class IgvTools {

    public static void main(String[] argv) {

        if (argv.length == 0) {
            System.out.println(usageString());
            System.exit(-1);
        }

        int nArgs = argv.length - 1;
        String[] args = new String[nArgs];
        System.arraycopy(argv, 1, args, 0, nArgs);

        String command = argv[0];
        if (command.toLowerCase().equals("sort")) {
            doSort(argv);
        } else if (command.toLowerCase().equals("index")) {
            doIndex(argv);

        } else if (command.toLowerCase().equals("pre")) {
            String ifile = args[0];
            if (ifile.endsWith(".txt")) {
                ifile = ifile.substring(0, ifile.length() - 4);
            }
            if (ifile.endsWith(".cbs") || ifile.endsWith(".seg")) {
                doPreprocessSeg(args);
            } else {
                doPreprocess(args);
            }
        } else if (command.toLowerCase().equals("wigsample")) {
            doWigSampling(args);
        } else if(command.toLowerCase().equals("wibtowig")) {
            UCSCUtils.main(args);
        }

        else {
            System.out.println("Unknown command: " + argv[0]);
            System.out.println(usageString());
        }

    }

    static String usageString() {
        StringBuffer buf = new StringBuffer();

        buf.append("\nProgram: igvtools\n\n");
        buf.append("Usage: igvtools <command> [options]\n\n");
        buf.append("Command:");
        for (String c : commandDocs) {
            buf.append(" " + c + "\n\t");

        }
        return buf.toString();
    }
    static String[] commandDocs = new String[]{
        "sort   sort a .aligned file by start position",
        "index   index an alignment file",
        "pre    preprocess an igv input file (cn, gct, wig)"
    };

    private static void doPreprocess(String[] args) {
        try {
            IGVPreprocessor.main(args);
        } catch (Exception ex) {
            System.err.println("Error preprocessing: " + printArgs(args));
            ex.printStackTrace();
        }
    }

    private static void doPreprocessSeg(String[] args) {
        try {
            SegmentedDataWriter.main(args);
        } catch (Exception ex) {
            System.err.println("Error preprocessing: " + printArgs(args));
            ex.printStackTrace();
        }

    }

    private static void doIndex(String[] argv) {
        if (argv.length < 2) {
            System.out.println("Usage: igvtools index <alignmentFile>");
            System.exit(-1);
        }
        File inputFile = new File(argv[1]);
        AlignmentIndexer indexer = AlignmentIndexer.getInstance(inputFile, null, null);
        try {
            indexer.createSamIndex();
        } catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
    }

    private static void doSort(String[] argv) {
        String[] args = new String[argv.length - 1];
        System.arraycopy(argv, 1, args, 0, argv.length - 1);
        (new DotAlignedSorter()).run(args);
    }

    private static void doWigSampling(String[] args) {
        WigSampler.main(args);
    }

    private static String printArgs(String[] args) {
        StringBuffer buf = new StringBuffer(100);
        for (int i = 0; i < args.length; i++) {
            buf.append(args[i]);
        }
        return buf.toString();
    }
}
