/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/

package org.broad.igv.synteny;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Strand;


/**
 *  // TODO -- consider implementing feature interface
 *
 * @author jrobinso
 */
public class Mapping extends BasicFeature {

    private Block queryBlock;
    private Block subjectBlock;

    /**
     * Constructs ...
     *
     *
     * @param queryBlock
     * @param subjectBlock
     * @param percentIden
     */
    public Mapping(Block queryBlock, Block subjectBlock, float percentIden) {
        this.queryBlock = queryBlock;
        this.subjectBlock = subjectBlock;
        
        this.setStart(Math.min(queryBlock.getStart(), queryBlock.getEnd()));
        this.setEnd(Math.max(queryBlock.getStart(), queryBlock.getEnd()));
        this.setName( "[" + subjectBlock.getContig() + ":" + subjectBlock.getStart() + "-"
               + subjectBlock.getEnd() + "]");
        this.setScore(percentIden);
        
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Block getQueryBlock() {
        return queryBlock;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Block getSubjectBlock() {
        return subjectBlock;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    @Override
    public String getChromosome() {
        return queryBlock.getContig();
    }

    public Strand getStrand() {
        return subjectBlock.getStrand();
    }


}
