/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/



package org.broad.igv.synteny;

import org.broad.igv.feature.Strand;


/**
 *
 * @author jrobinso
 */
public class Block {

    private String contig;
    private int start;
    private int end;
    Strand strand;

    /**
     * Constructs ...
     *
     *
     * @param contig
     * @param start
     * @param end
     */
    public Block(String contig, int start, int end, Strand strand) {
        this.contig = contig;
        this.start = start;
        this.end = end;
        this.strand = strand;
    }


    /**
     * Method description
     *
     *
     * @return
     */
    public String getContig() {
        return contig;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getStart() {
        return start;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public int getEnd() {
        return end;
    }
    
    public Strand getStrand() {
        return strand;
    }

}
