/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.session;

//~--- non-JDK imports --------------------------------------------------------

import org.broad.igv.*;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.renderer.ColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.RendererFactory;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackManager;
import org.broad.igv.track.TrackManager.MatchTrack;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.ui.IGVModel;
import org.broad.igv.ui.RegionOfInterest;
import org.broad.igv.ui.TrackFilter;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 *
 * @author eflakes
 */
public class Session  {

    private static int versionNumber = 2;

    private String filePath;

    /**
     * Constructs ...
     *
     *
     * @param filePath
     */
    public Session(String filePath) {
        this.filePath = filePath;
    }

    /**
     * @return the absolute path to the file associated with this session
     */
    public String getPath() {
        return filePath;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getSessionVersion() {
        return String.valueOf(versionNumber);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getGenome() {
        return IGVModel.getInstance().getViewContext().getGenomeId();
    }

    /**
     * Method description
     *
     *
     * @param genome
     */
    public void setGenome(String genome) {
        String id = IGVModel.getInstance().getViewContext().getGenomeId();
        if ((id == null) ||!id.equalsIgnoreCase(genome))
        {
            IGVMainFrame.getInstance().selectGenomeFromList(genome);
        }
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getGroupTracksBy() {
        return TrackManager.getInstance().getGroupByAttribute();
    }

    /**
     * Method description
     *
     *
     * @param groupTracksBy
     */
    public void setGroupTracksBy(String groupTracksBy) {
        TrackManager.getInstance().setGroupByAttribute(groupTracksBy);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getLocus() {
        return locusString;
    }
    String locusString;

    /**
     * Method description
     *
     *
     * @param locus
     */
    public void setLocus(String locus) {

        // IGVMainFrame.getInstance().setCurrentLocus(locus);
        this.locusString = locus;
    }

    /**
     * @return A set of the loadd data files.
     */
    public Collection<ResourceLocator> getResourceLocatorSet() {

        Collection<ResourceLocator> locators = new ArrayList();

        Collection<ResourceLocator> currentTrackFileLocators =
            TrackManager.getInstance().getDataResourceLocators();

        if (currentTrackFileLocators != null)
        {
            for (ResourceLocator locator : currentTrackFileLocators)
            {
                locators.add(locator);
            }
        }

        Collection<ResourceLocator> loadedAttributeResources =
            AttributeManager.getInstance().getLoadedResources();

        if (loadedAttributeResources != null)
        {
            for (ResourceLocator attributeLocator : loadedAttributeResources)
            {
                locators.add(attributeLocator);
            }
        }

        return locators;
    }

    /**
     * Method description
     *
     *
     * @param region
     */
    public void addRegionOfInterest(RegionOfInterest region) {

        // TODO -- jtr.  Originally the region was added without listeners
        // was there a reason to do this?
        // model.addRegionOfInterestWithNoListeners(region);
        IGVMainFrame.getInstance().addRegionOfInterest(region);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Collection<RegionOfInterest> getRegionsOfInterestSet() {

        IGVModel model = IGVModel.getInstance();
        Collection<RegionOfInterest> regions =
            model.getRegionsOfInterest(model.getViewContext().getChrName());

        return regions;
    }

    /**
     * Method description
     *
     *
     * @param visibleAttributes
     */
    public void setVisibleAttributes(Collection<String> visibleAttributes) {

        if ((visibleAttributes == null) || (visibleAttributes.size() == 0))
        {
            return;
        }

        StringBuffer buffer = new StringBuffer();
        for (String attribute : visibleAttributes)
        {
            buffer.append(attribute);
            buffer.append(",");
        }
        String visibleAttributeString = buffer.toString();
        if ((visibleAttributeString != null) && (visibleAttributeString.length() > 0))
        {

            List<String> allAttributeNames = AttributeManager.getInstance().getAttributeKeys();

            boolean clearListFirst = true;
            Boolean defaultCheckState = new Boolean(false);
            IGVMainFrame.getInstance().setupDisplayableAttributePreferences(allAttributeNames,
                    visibleAttributeString, defaultCheckState, clearListFirst);
        }
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Collection<String> getVisibleAttributes() {
        return IGVMainFrame.getInstance().getDisplayableAttributes();
    }

    /**
     * Method description
     *
     *
     * @param type
     * @param value
     */
    public void setColorScaleSet(String type, String value) {

        if (type == null | value == null)
        {
            return;
        }

        TrackType trackType = TrackType.OTHER;

        if (TrackType.ALLELE_SPECIFIC_COPY_NUMBER.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.ALLELE_SPECIFIC_COPY_NUMBER;
        }
        else if (TrackType.CHIP.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.CHIP;
        }
        else if (TrackType.COPY_NUMBER.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.COPY_NUMBER;
        }
        else if (TrackType.DNA_METHYLATION.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.DNA_METHYLATION;
        }
        else if (TrackType.OTHER.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.OTHER;
        }
        else if (TrackType.GENE_EXPRESSION.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.GENE_EXPRESSION;
        }
        else if (TrackType.LOH.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.LOH;
        }
        else if (TrackType.MUTATION.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.MUTATION;
        }
        else if (TrackType.PHASTCON.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.PHASTCON;
        }
        else if (TrackType.TILING_ARRAY.name().equalsIgnoreCase(type))
        {
            trackType = TrackType.TILING_ARRAY;
        }

        // TODO -- we really shouldn't be overriding user preferences here but currently
        // its the only way to change a color scale.
        // ColorScale colorScale = ColorScaleFactory.getScaleFromString(value);
        PreferenceManager.getInstance().setColorScaleString(trackType, value);

        // ColorScaleFactory.setColorScale(trackType, colorScale);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Map<TrackType, ColorScale> getColorScaleMap() {

        Map<TrackType, ColorScale> map = null;
        List<Track> tracks = TrackManager.getInstance().getAllTracks(true);
        for (Track track : tracks)
        {
            if (map == null)
            {
                map = new HashMap();
            }
            TrackType type = track.getTrackType();
            if (!map.containsKey(type))
            {
                map.put(type, PreferenceManager.getInstance().getColorScale(type));
            }
        }

        if (map.isEmpty())
        {
            map = null;
        }
        return map;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public TrackFilter getFilter() {
        return filter;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isFilterMatchAll() {
        return IGVMainFrame.getInstance().isFilterMatchAll();
    }

    /**
     * Method description
     *
     *
     * @param filterMatchAll
     */
    public void setFilterMatchAll(boolean filterMatchAll) {
        IGVMainFrame.getInstance().setFilterMatchAll(filterMatchAll);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isFilterMatchAny() {
        return !IGVMainFrame.getInstance().isFilterMatchAll();
    }

    /**
     * Method description
     *
     *
     * @param filterMatchAny
     */
    public void setFilterMatchAny(boolean filterMatchAny) {
        IGVMainFrame.getInstance().setFilterMatchAll(!filterMatchAny);
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isFilterShowAllTracks() {
        return IGVMainFrame.getInstance().isFilterShowAllTracks();
    }

    /**
     * Method description
     *
     *
     * @param filterShowAllTracks
     */
    public void setFilterShowAllTracks(boolean filterShowAllTracks) {
        IGVMainFrame.getInstance().setFilterShowAllTracks(filterShowAllTracks);
    }

    /**
     * Method description
     *
     *
     * @param filter
     */
    TrackFilter filter;

    /**
     * Method description
     *
     *
     * @param filter
     */
    public void setFilter(TrackFilter filter) {
        this.filter = filter;

        // IGVMainFrame.getInstance().setTrackFilter(filter);
    }


    public void updateTrack(String id, String displayName, String isVisible, String height, String color,
                             String rendererType, String windowFunction, String scale,
                             String isExpanded) {//, List<Track> tracks) {

        List<Track> matchedTracks = null;
            matchedTracks = TrackManager.getInstance().findTracksById(id, MatchTrack.EXACT);
        for (final Track track : matchedTracks)
        {
            if(displayName != null) {
                track.setDisplayName(displayName);
            }

            // Set visibility
            if (isVisible != null)
            {
                if (isVisible.equalsIgnoreCase("true"))
                {
                    track.setVisible(true);
                }
                else
                {
                    track.setVisible(false);
                }
            }

            // Set height
            if (height != null)
            {
                track.setHeight(Integer.parseInt(height));
            }

            // Set color
            if (color != null)
            {
                String[] rgb = color.split(",");
                int red = Integer.parseInt(rgb[0]);
                int green = Integer.parseInt(rgb[1]);
                int blue = Integer.parseInt(rgb[2]);
                track.setColor(new Color(red, green, blue));
            }

            // Set rendererClass
            if (rendererType != null)
            {
                Class rendererClass = RendererFactory.getRendererClass(rendererType);
                if (rendererClass != null)
                {
                    track.setRendererClass(rendererClass);
                }
            }

            // Set window function
            if (windowFunction != null)
            {
                track.setStatType(WindowFunction.getWindowFunction(windowFunction));
            }

            // Set DataRange
            if (scale != null)
            {
                String[] axis = scale.split(",");
                float minimum = Float.parseFloat(axis[0]);
                float baseline = Float.parseFloat(axis[1]);
                float maximum = Float.parseFloat(axis[2]);
                track.setDataRange(new DataRange(minimum, baseline, maximum));
            }

            // Set expand
            if (isExpanded != null)
            {
                track.setExpanded(isExpanded.equalsIgnoreCase("true"));
            }
        }
    }
    
    public Collection<String> getPanelNames() {
        return TrackManager.getInstance().getPanelNames();
    }
    
    public List<Track> getTracks(String panelName) {
        return TrackManager.getInstance().getTracksForPanel(panelName);
    }
 
    /**
     * Method description
     *
     *
     * @return
     */
    public List<Track> getDataTracks() {
        return TrackManager.getInstance().getDataTracks();
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public List<Track> getFeatureTracks() {
        return TrackManager.getInstance().getFeatureTracks();
    }
}
