/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.sam.reader;

//~--- non-JDK imports --------------------------------------------------------

//~--- JDK imports ------------------------------------------------------------
import org.broad.igv.sam.reader.SamIndexCreatorDialog;
import org.broad.igv.sam.reader.SamIndex;
import java.io.File;
import org.broad.igv.IGVConstants;
import org.broad.igv.ui.IGVMainFrame;
import org.broad.igv.util.FileUtils;

/**
 *
 * @author jrobinso
 */
public class SamUtils {

    // 10 KB window
    private static int DEFAULT_TILE_WIDTH = 100000;

    public static SamIndex getIndexFor(File samFile) {

        File idxFile = new File(samFile.getAbsolutePath() + ".sai");
        if (!idxFile.exists())
        {
            idxFile = getUserIdxFile(samFile);
        }
        if (idxFile.exists() && idxFile.lastModified() > samFile.lastModified())
        {
            return new SamIndex(idxFile);
        } else
        {
            return createIndexFor(samFile);
        }
    }

    private static SamIndex createIndexFor(File samFile) {
        File newIdxFile = new File(samFile.getAbsolutePath() + ".sai");
        if (!FileUtils.canWriteTo(newIdxFile))
        {
            newIdxFile = getUserIdxFile(samFile);
        }

        SamIndexCreatorDialog dialog = new SamIndexCreatorDialog(IGVMainFrame.getInstance(), true, samFile, newIdxFile);
        dialog.setLocationRelativeTo(IGVMainFrame.getInstance());
        dialog.setVisible(true);
        return dialog.getIndex();
    }

    private static File getUserIdxFile(File samFile) {
        File idxFile;
        File samDir = new File(IGVConstants.DEFAULT_IGV_DIRECTORY, "sam");
        //Need the path information to distinguish like name indeces in separate
        // directories.
        idxFile = new File(samDir, samFile.getName() + "_" + samFile.getParent().hashCode() + ".sai");
        return idxFile;
    }
}
