/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import org.broad.igv.util.ResourceLocator;

/**
 *
 * @author jrobinso
 */
public class SamQueryReaderFactory {

    public static AlignmentQueryReader getReader(ResourceLocator locator) {

        String path = locator.getPath().toLowerCase();

        if (path.endsWith(".sam.group"))
        {
            return new CachingQueryReader(new SamGroupQueryReader(locator));
        }

        if (locator.isLocal())
        {
            File samFile = new File(locator.getPath());
            if (path.endsWith(".bam"))
            {
                return new CachingQueryReader(new BAMQueryReader(samFile));
            } else if(path.endsWith(".sam"))
            {
                //return new SamInMemoryQueryReader(samFile);
                return new CachingQueryReader(new SamQueryTextReader(samFile));
            }
            else if(path.endsWith("sorted.txt") || path.endsWith(".aligned")) {
                return new CachingQueryReader(new GeraldQueryReader(samFile));
            }
            else {
                throw new RuntimeException("Unknown file type: " + locator.getPath());
            }
        } else
        {
            return new CachingQueryReader(
                    new SamRemoteQueryReader(locator));
                   // new SamRemoteQueryReader(locator));
        }
    }

}

