/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
package org.broad.igv.sam.reader;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

/**
 *  
 * 
 * @author jrobinso
 */
public class SAMFileGroup implements Iterable<SAMRecord> {

    // Map of chromosome -> file
    File[] samFiles;

    public SAMFileGroup(File[] samFiles) {
        this.samFiles = samFiles;
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public SAMFileHeader getHeader() {
        if (samFiles.length == 0)
        {
            return null;
        }
        SAMFileReader reader = new SAMFileReader(samFiles[0]);
        SAMFileHeader header = reader.getFileHeader();
        reader.close();
        ;
        return header;
    }

    public Iterator<SAMRecord> iterator() {
        return new SamGroupIterator();
    }

    public class SamGroupIterator implements CloseableIterator<SAMRecord> {

        int idx;
        SAMFileReader currentReader;
        CloseableIterator<SAMRecord> currentIter;
        SAMRecord next;

        SamGroupIterator() {
            idx = 0;
            advance();
        }

        public void close() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean hasNext() {
            return next != null;
        }

        public SAMRecord next() {
            SAMRecord ret = next;
            advance();
            return ret;
        }

        private void advance() {
            if (currentIter == null || !currentIter.hasNext())
            {
                if (currentIter != null)
                {
                    currentIter.close();
                    currentIter = null;
                }
                if (currentReader != null)
                {
                    currentReader.close();
                }
                if (idx < samFiles.length)
                {
                    currentReader = new SAMFileReader(samFiles[idx]);
                    currentIter = currentReader.iterator();
                    idx++;
                }
            }
            next = currentIter == null ? null : currentIter.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

