/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.sam.reader;

import org.broad.igv.sam.*;
import net.sf.samtools.util.AsciiLineReader;
import org.broad.igv.feature.ParsingUtils;

/**
 *
 * @author jrobinso
 */
public class DotAlignedParser implements AlignmentParser {

    public static final int CHROMOSOME_COLUMN = 0;
    private static final int START_COLUMN = 1;
    private static final int END_COLUMN = 2;
    private static final int STRAND_COLUMN = 3;
    private String[] fields = new String[STRAND_COLUMN + 1];

    public DotAlignedAlignment readNextRecord(AsciiLineReader reader) {
        String nextLine = reader.readLine();
        if (nextLine == null) {
            return null;
        }
        return createAlignment(nextLine);
    }

    private DotAlignedAlignment createAlignment(String nextLine) {


        int nTokens = ParsingUtils.split(nextLine, fields, '\t');
        // TODO -- what to do if nTokens < 4?

        String chr = fields[0];
        int start = Integer.parseInt(fields[START_COLUMN]);
        int end = Integer.parseInt(fields[END_COLUMN]);
        boolean isNegative = fields[STRAND_COLUMN].equals("-");

        return new DotAlignedAlignment(chr, start, end, isNegative);
    }
}
