/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.sam.reader;

import org.broad.igv.sam.*;
import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMFileReader.ValidationStringency;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;

/**
 *
 * @author jrobinso
 */
public class BAMQueryReader implements AlignmentQueryReader {

    SAMFileReader reader;
    SAMFileHeader header;
    
    public BAMQueryReader(File samFile) {
        try {
            reader = new SAMFileReader(samFile);
            reader.setValidationStringency(ValidationStringency.SILENT);
            loadHeader();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public SAMFileHeader getHeader() {
        if(header != null) {
            loadHeader();
        }
        return header;
    }

    private void loadHeader() {
        header = reader.getFileHeader();
    }
    public void close() throws IOException {
        reader.close();
    }

    public CloseableIterator<Alignment> query(String sequence, int start, int end, boolean contained) {
        return new WrappedIterator(reader.query(sequence, start, end, contained));
    }

    public class WrappedIterator implements CloseableIterator<Alignment> {

        CloseableIterator<SAMRecord> iter;

        WrappedIterator(CloseableIterator<SAMRecord> iter) {
            this.iter = iter;
        }

        public void close() {
            iter.close();
        }

        public boolean hasNext() {
            return iter.hasNext();
        }

        public Alignment next() {
            return new SamAlignment(iter.next());
        }

        public void remove() {
            iter.remove();
        }

    }
}
