/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.sam;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.feature.Strand;
import org.broad.igv.track.WindowFunction;

/**
 *

 *
 * @author jrobinso
 */
public class GeraldAlignment extends AbstractAlignment implements Alignment {

    private boolean passedFilter;
    private String readSequence = null;
    private int start;
    private int end;

    public GeraldAlignment(String name) {
        this.readName = name;
    }

    public GeraldAlignment(GeraldAlignment alignment) {
        super(alignment);
    }

    public void setReads(String chr, int start, byte[] reads, byte[] qualities) {
        this.chr = chr;
        this.insertions = new AlignmentBlock[0];
        this.alignmentBlocks = new AlignmentBlock[1];
        this.alignmentBlocks[0] = new AlignmentBlock(start, reads, qualities);
        this.start = start;
        this.end = start + reads.length;
    }

    public String getReadSequence() {
        if(readSequence == null) {
            readSequence = new String(this.alignmentBlocks[0].getBases());
        }
        return readSequence;
    }


    public LocusScore copy() {
        return new GeraldAlignment(this);
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        String str = super.getValueString(position, windowFunction);
        if(!passedFilter) {
            str += "<br>--------------<br>" + "FAILED QUALITY FILTERING";
        }
        return str;
    }

    public String getCigarString() {
        return "*";
    }

    public AlignmentBlock[] getInsertions() {
        return insertions;
    }

    public boolean isProperPair() {
        return isPaired();
    }

    public int getAlignmentStart() {
        return alignmentBlocks[0].getStart();
    }

    public boolean isDuplicate() {
        return false;
    }

    public boolean isMapped() {
        return getChromosome() != null;
    }

    public boolean isPaired() {
        return this.getMate() != null;
    }

    /**
     * @return the passedFilter
     */
    public boolean isPassedFilter() {
        return passedFilter;
    }

    /**
     * @param passedFilter the passedFilter to set
     */
    public void setPassedFilter(boolean passedFilter) {
        this.passedFilter = passedFilter;
    }

    public int getAlignmentEnd() {
        return end;
    }

    public int getStart() {
        return start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return end;
    }

    public void setEnd(int end) {
        this.end = end;
    }


}
