/*
* The Broad Institute
* SOFTWARE COPYRIGHT NOTICE AGREEMENT
* This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
* of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
* (the "License"); you may not use this file except in compliance with
*  the License.  You may obtain a copy of the License at
*
*    http://www.opensource.org/licenses/gpl-2.0.php
*
* This software is supplied without any warranty or guaranteed support
* whatsoever. Neither the Broad Institute nor MIT can be responsible for its
* use, misuse, or functionality.
*/



package org.broad.igv.roc;


/**
 *
 * @author jrobinso
 */
public class ROCScore implements Comparable<ROCScore> {

    private double auc;
    private String gene;

    /**
     * Constructs ...
     *
     *
     * @param auc
     * @param gene
     */
    public ROCScore(double auc, String gene) {
        this.auc = auc;
        this.gene = gene;
    }



    /**
     * Method description
     *
     *
     * @return
     */
    public double getAUC() {
        return auc;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public String getGene() {
        return gene;
    }

    /**
     * Method description
     *
     *
     * @param score
     *
     * @return
     */
    public int compareTo(ROCScore score) {
        return (int) (this.auc - score.auc);
    }



}
