/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.renderer;

import org.broad.igv.feature.SequenceManager;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGVModel;

/**
 *
 * @author jrobinso
 */
public class SequenceRenderer  implements Renderer {

    static Map<Character, Color> nucleotideColors = new HashMap();

    static {
        //nucleotideColors.put('A', new Color(160, 160, 255));
        //nucleotideColors.put('C', new Color(255, 140, 75));
        //nucleotideColors.put('T', new Color(160, 255, 255));
        //nucleotideColors.put('G', new Color(255, 112, 112));
        //nucleotideColors.put('N', Color.gray);    
        nucleotideColors.put('A', Color.GREEN);
        nucleotideColors.put('a', Color.GREEN);
        nucleotideColors.put('C', Color.BLUE);
        nucleotideColors.put('c', Color.BLUE);
        nucleotideColors.put('T', Color.RED);
        nucleotideColors.put('t', Color.RED);
        nucleotideColors.put('G', new Color(242, 182, 65));
        nucleotideColors.put('g', new Color(242, 182, 65));
        nucleotideColors.put('N', Color.gray);
        nucleotideColors.put('n', Color.gray);
    }

    // For efficiency
    //@Override
    public void draw(RenderContext context, Rectangle trackRectangle) {

        double locScale = context.getScale();
        double origin = context.getOrigin();
        String chr = context.getChr();
        String genome = IGVModel.getInstance().getViewContext().getGenomeId();

        int start = (int) origin;
        int end = (int) (origin + trackRectangle.width * locScale) + 1;
        byte[] seq = SequenceManager.readSequence(genome, chr, start, end);
        if (seq != null && seq.length > 0) {
            int pY = (int) trackRectangle.getY() + 2;
            int dY = (int) trackRectangle.getHeight() - 4;
            int dX = (int) (1.0 / locScale);
            // Create a graphics to use
            Graphics2D g = (Graphics2D) context.getGraphics().create();
            if (dX >= 8) {
                Font f = FontManager.getScalableFont(Font.BOLD, Math.min(dX, 12));
                g.setFont(f);
            }

            // Loop through base pair coordinates
            for (int loc = start; loc < end; loc++) {

                int pX0 = (int) ((loc - origin) / locScale);

                char c = (char) seq[loc - start];
                Color color = nucleotideColors.get(c);

                if (dX >= 8) {
                     if (color == null) {
                        color = Color.black;
                    }
                    g.setColor(color);
                    drawCenteredText(g, new char[]{c}, pX0, pY + 2, dX, dY - 2);
                } else {
                    int bw = dX - 1;
                    if (color != null) {
                        g.setColor(color);
                        g.fillRect(pX0, pY, bw, dY);
                    }

                }
            }
        }
    }

    private void drawCenteredText(Graphics2D g, char[] chars, int x, int y, int w, int h) {
        // Get measures needed to center the message
        FontMetrics fm = g.getFontMetrics();

        // How many pixels wide is the string
        int msg_width = fm.charsWidth(chars, 0, 1);

        // How far above the baseline can the font go?
        int ascent = fm.getMaxAscent();

        // How far below the baseline?
        int descent = fm.getMaxDescent();

        // Use the string width to find the starting point
        int msgX = x + w / 2 - msg_width / 2;

        // Use the vertical height of this font to find
        // the vertical starting coordinate
        int msgY = y + h / 2 - descent / 2 + ascent / 2;

        g.drawChars(chars, 0, 1, msgX, msgY);

    }

    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
       
        
    }

    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
        
        
    }

    public void setOverlayMode(boolean overlayMode) {
       
        
    }

    public Color getDefaultColor() {
        return Color.BLACK;
    }


}
