/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.renderer;

/**
 *
 * @author eflakes
 */
public class RendererFactory {

    static public enum RendererType {

        BAR_CHART,
        BASIC_FEATURE,
        FEATURE_DENSITY,
        GENE_TRACK,
        GISTIC_TRACK,
        HEATMAP,
        MUTATION,
        SCATTER_PLOT,
        LINE_PLOT
    }
    static Class defaultRendererClass = BarChartRenderer.class;

    static public Class getRendererClass(String rendererTypeName) {

        Class rendererClass = null;
        String typeName = rendererTypeName.toUpperCase();

        if (typeName.equals(RendererType.BAR_CHART.name()) || typeName.equals("BAR")) {
            rendererClass = BarChartRenderer.class;
        } else if (typeName.equals(RendererType.BASIC_FEATURE.name())) {
            rendererClass = BasicFeatureRenderer.class;
        } else if (typeName.equals(RendererType.FEATURE_DENSITY.name())) {
            rendererClass = FeatureDensityRenderer.class;
        } else if (typeName.equals(RendererType.GENE_TRACK.name())) {
            rendererClass = GeneTrackRenderer.class;
        } else if (typeName.equals(RendererType.GISTIC_TRACK.name())) {
            rendererClass = GisticTrackRenderer.class;
        } else if (typeName.equals(RendererType.HEATMAP.name())) {
            rendererClass = HeatmapRenderer.class;
        } else if (typeName.equals(RendererType.MUTATION.name())) {
            rendererClass = MutationRenderer.class;
        } else if (typeName.equals(RendererType.SCATTER_PLOT.name()) ||
                typeName.toUpperCase().equals("POINTS")) {
            rendererClass = ScatterplotRenderer.class;
        }
        else if (typeName.equals(RendererType.LINE_PLOT.name()) ||
                typeName.toUpperCase().equals("LINE")) {
            rendererClass = LineplotRenderer.class;
        }
        return rendererClass;
    }

    static public RendererType getRenderType(Renderer renderer) {
        return getRenderType(renderer.getClass());
    }

    static public RendererType getRenderType(Class rendererClass) {

        RendererType rendererType = null;

        if (rendererClass.equals(BarChartRenderer.class)) {
            rendererType = RendererType.BAR_CHART;
        } else if (rendererClass.equals(BasicFeatureRenderer.class)) {
            rendererType = RendererType.BASIC_FEATURE;
        } else if (rendererClass.equals(FeatureDensityRenderer.class)) {
            rendererType = RendererType.FEATURE_DENSITY;
        } else if (rendererClass.equals(GeneTrackRenderer.class)) {
            rendererType = RendererType.GENE_TRACK;
        } else if (rendererClass.equals(GisticTrackRenderer.class)) {
            rendererType = RendererType.GISTIC_TRACK;
        } else if (rendererClass.equals(HeatmapRenderer.class)) {
            rendererType = RendererType.HEATMAP;
        } else if (rendererClass.equals(MutationRenderer.class)) {
            rendererType = RendererType.MUTATION;
        } else if (rendererClass.equals(ScatterplotRenderer.class)) {
            rendererType = RendererType.SCATTER_PLOT;
        }
        else if (rendererClass.equals(LineplotRenderer.class)) {
            rendererType = RendererType.LINE_PLOT;
        }
        return rendererType;
    }
}
