/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package org.broad.igv.renderer;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.IGVConstants;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ColorUtilities;

/**
 * A simple lookup color scale backed by a map.  
 * @author jrobinso
 */
public class MappedColorScale extends AbstractColorScale {

    public static String serializationClassId = "MappedColorScale";
    Color defaultColor = Color.black;
    Color noDataColor = IGVConstants.NO_DATA_COLOR;
    Map<String, Color> colorMap;
    

    /**
     * Construct an instance from a serizled string representation.
     * @param serializedInstance
     */
    public MappedColorScale(String serializedInstance) {
        
        colorMap = new HashMap<String, Color>();
        
        String [] tokens = serializedInstance.split(";");
        
        // First token is class string -- todo, validate this?
        for(int i=1; i < tokens.length; i++) {
            String [] keyValue = tokens[i].split(" ");
            if(keyValue.length == 2) {
                String key = keyValue[0].trim();
                Color c = ColorUtilities.convertRGBStringToColor(keyValue[1]);
                colorMap.put(key, c);
            }
        }
    }
    
    /**
     * Construct an instance from a color map
     * @param colorMap
     */
    public MappedColorScale(Map<String, Color> colorMap) {
        this.colorMap = new HashMap<String, Color> ();
        this.colorMap.putAll(colorMap);
    }
    
    /**
     * Return a string representing the state fo this instance
     * @return
     */
    public String asString() {
        StringBuffer buf = new StringBuffer();
        buf.append(serializationClassId );
        for(Map.Entry<String,Color> mapEntry : colorMap.entrySet()) {
            buf.append(";");
            buf.append(mapEntry.getKey() + " ");
            buf.append(ColorUtilities.convertColorToRGBString(mapEntry.getValue()));
            
        }
        return buf.toString();
    }
    
    
    /**
     * 
     * @return the number of entries in this instance
     */
    public int getSize() {
        return colorMap.size();
    }
    
    /**
     * Comparison method.  Primary use is to support unit tests.
     * @param anotherCS
     * @return
     */
    public boolean isSame(MappedColorScale anotherCS) {
        
        if(this.getSize() != anotherCS.getSize()) {
            return false;
        }
       for(String key : colorMap.keySet()) {
           if(!this.getColor(key).equals(anotherCS.getColor(key))) {
               return false;
           }
       }
       return true;
        
    }
    
    @Override
    public Color getColor(String key) {
        return colorMap.containsKey(key) ? colorMap.get(key) : defaultColor;
    }
    
    public Color getNoDataColor() {
        return noDataColor;
    }

}
