/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.List;
import org.broad.igv.feature.GisticScore;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

/**
 *
 * @author jrobinso
 */
public class GisticTrackRenderer implements Renderer {

    public void setOverlayMode(boolean mode) {
    // Ignore for now
    }

    public void render(Track track, RenderContext context, Rectangle rect) {

        // I only know how to render gistic tracks
        if (!(track instanceof GisticTrack))
        {
            return;
        }

        plotScores(track, context, rect);


    }

    public Color getDefaultColor() {
        return Color.BLUE;
    }

    protected void plotScoresOn(List<GisticScore> scores, Graphics2D g2D, Rectangle rect, int xEnd,
                                 double scale, RenderContext vc, int xStart, int yStart) {

        double origin = vc.getOrigin();
        double locScale = vc.getScale();

        int lastY = yStart;
        double lastX = xStart;
        for (GisticScore score : scores)
        {
            double scaledY = scale * transform(score.getQValue());
            int y = (int) (rect.getMaxY() - scaledY);

            // Compute X values in double precision to prevent overflow at extreme
            // scales.  Cast to ints after range is checked.
            double x1 = ((score.getStart() - 1 - origin) / locScale);
            double x2 = ((score.getEnd() - origin) / locScale);
            if (x2 > rect.getX() && lastX < rect.getMaxX())
            {
                g2D.drawLine((int) lastX, lastY, (int) x1, y);
                g2D.drawLine((int) x1, y, (int) x2, y);
            }
            lastY = y;
            lastX = x2;
        }
        if (xEnd > rect.getX() && lastX < rect.getMaxX())
        {
            g2D.drawLine((int) lastX, lastY, xEnd, yStart);
        }
    }

    // TODO -- need to combine the amp and del regions with a parameter.  Remove
    // duplicated code.
    private void plotScores(Track track, RenderContext context, Rectangle rect) {

        GisticTrack gisticTrack = (GisticTrack) track;
        String chr = context.getChr();

        // GisticScoreList ampScores = GisticManager.getInstance().getAmpScores();
        // GisticScoreList delScores = GisticManager.getInstance().getDelScores();
        // double          maxQValue = Math.max(ampScores.getMaxQValue(), delScores.getMaxQValue());
        float maxQValue = transform(track.getAxisDefinition().getMaximum());
        if (maxQValue > 0)
        {
            double scale = (rect.getHeight() - 5) / maxQValue;

            // TODO use offset
            int xStart = (int) rect.getX();
            int yStart = (int) rect.getMaxY();

            //long chromosomeEnd = offset + Genome.getInstance().getChromosomeLength(chr);
            int xEnd = (int) rect.getWidth(); //vc.getPy(chromosomeEnd) - 1;

            List<GisticScore> scores = gisticTrack.getAmpScores(chr);
            if (scores != null)
            {
                Graphics2D g2D = context.getGraphic2DForColor(Color.RED);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, // Anti-alias!
                    RenderingHints.VALUE_ANTIALIAS_ON);
                plotScoresOn(scores, g2D, rect, xEnd, scale, context, xStart, yStart);
            }

            scores = gisticTrack.getDelScores(chr);
            if (scores != null)
            {
                Graphics2D g2D = context.getGraphic2DForColor(Color.BLUE);
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, // Anti-alias!
                    RenderingHints.VALUE_ANTIALIAS_ON);
                plotScoresOn(scores, g2D, rect, xEnd, scale, context, xStart, yStart);
            }

        //draw a single line at qvalue = 0.6;
        //int y = (int) (rect.getMaxY() - scale * Math.log(1 - Math.log(0.25)));
        //Graphics2D g2D = context.getGraphic2DForColor(Color.GREEN.darker());
        //g2D.drawLine(xStart, y, xEnd, y);
        }
    }

    public float transform(double value) {
        return (float) Math.log(1 + value);
    }

    /**
     * Render a border.  By default does nothing.
     * @param track
     * @param context
     * @param rect
     */
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {
        context.getGraphic2DForColor(Color.gray).drawRect(rect.x, rect.y, rect.width, rect.height);
    }

    /**
     * Render a Y axis.  TODO -- implementation
     * @param track
     * @param context
     * @param rect
     */
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {

    }
}
