/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Feature;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

/**
 *
 * @author jrobinso
 */
public abstract class FeatureRenderer implements Renderer {

    boolean overlayMode = false;

    private static Color defaultColor = new Color(0, 0, 150);

    final HashMap<Color, Graphics2D> graphicCacheByColor = new HashMap<Color, Graphics2D>();

    /**
     * Return the pixel position corresponding to the chromosomal position.
     */
    private static Logger log = Logger.getLogger(FeatureRenderer.class);


    public void setOverlayMode(boolean overlayMode) {
        this.overlayMode = overlayMode;
    }

    public boolean getOverlayMode() {
        return overlayMode;
    }
    

    
    

    /**
     * Render a border.  By default does nothing.
     * @param track
     * @param context
     * @param rect
     */
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {

    }
    
    /**
     * Render a Y axis.  By default does nothing.
     * @param track
     * @param context
     * @param rect
     */
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {

    }
    
    public Color getDefaultColor() {
        return defaultColor;
    }

    public abstract void renderFeatures(List<Feature> features, RenderContext context,
            Rectangle rect, Track track);
}
