/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * DataRenderer.java
 *
 * Created on November 27, 2007, 9:20 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */



package org.broad.igv.renderer;

//~--- non-JDK imports --------------------------------------------------------

import org.apache.log4j.Logger;

import org.broad.igv.IGVConstants;

import org.broad.igv.PreferenceManager;

import org.broad.igv.feature.LocusScore;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;

//~--- JDK imports ------------------------------------------------------------

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

import java.util.List;
import org.broad.igv.track.DataTrack;

/**
 *
 * @author jrobinso
 */
public abstract class DataRenderer implements Renderer {

    protected static final int AXIS_AREA_WIDTH = 60;
    protected static Color axisLineColor = new Color(255, 180, 180);
    private boolean overlayMode;
    private static Logger log = Logger.getLogger(DataRenderer.class);
    private static Color defaultColor = new Color(0, 0, 150);

    /** Field description */

    /** Field description */
    public static float confThreshold = 0.02f;

    /**
     * Set the overlay mode.  Subclasses can use this flag to alter rendering
     * if the track is being overlayed.
     *
     * @param mode
     */
    public void setOverlayMode(boolean mode) {
        this.overlayMode = mode;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean getOverlayMode() {
        return overlayMode;
    }

    /**
     * Render the track in the given rectangle.
     *
     * @param track
     * @param scores
     * @param context
     * @param arect
     */
    public void render(Track track, List<LocusScore> scores, RenderContext context,
                       Rectangle arect) {

        if (scores != null)
        {
            // Prevent modification of the scores collection during rendering.  This collection
            // has caused concurrent modification exceptions.
            synchronized (scores)
            {
                renderScores(track, scores, context, arect);
            }
        }

    }

    /**
     * Render a border.  By default does nothing.
     * @param track
     * @param context
     * @param rect
     */
    public void renderBorder(Track track, RenderContext context, Rectangle rect) {}

    /**
     * Render a Y axis.  By default does nothing.
     * @param track
     * @param context
     * @param rect
     */
    public void renderAxis(Track track, RenderContext context, Rectangle rect) {
        PreferenceManager.ChartPreferences prefs =
            PreferenceManager.getInstance().getChartPreferences();

        // For now disable axes for all chromosome view
        if (context.getChr().equals(IGVConstants.CHR_ALL))
        {
            return;
        }
        if (prefs.isDrawAxis())
        {

            Rectangle axisRect = new Rectangle(rect.x, rect.y + 1, AXIS_AREA_WIDTH, rect.height);
            Graphics2D whiteGraphics = context.getGraphic2DForColor(Color.white);

            whiteGraphics.fillRect(axisRect.x, axisRect.y, axisRect.width, axisRect.height);

            Graphics2D axisGraphics = context.getGraphic2DForColor(axisLineColor);

            axisGraphics.drawLine(rect.x + AXIS_AREA_WIDTH, rect.y, rect.x + AXIS_AREA_WIDTH,
                                  rect.y + rect.height);
        }


    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Color getDefaultColor() {
        return defaultColor;
    }

    protected abstract void renderScores(Track track, List<LocusScore> scores,
            RenderContext context, Rectangle arect);
}
