/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/



/*
* To change this template, choose Tools | Templates
* and open the template in the editor.
 */
package org.broad.igv.renderer;

/**
 * Encapsulates parameter for an x-y plot axis.
 *
 * @author jrobinso
 */
public class DataRange {


    enum Type { LOG, LINEAR }

    /** The scale type,  linear by default */
    private Type type = Type.LINEAR;

    /** Minimum data value displayed.  Zero by default. */
    private float minimum = 0;

    /** Where to draw the plot baseline.  Zero by default */
    private float baseline = 0;

    /** Maximum data value displayed. This value is required, no default */
    private float maximum;

    /** If true the Y axis is "flipped" (most negative value at top) */
    private boolean flipAxis = false;
    
    private boolean drawBaseline = true;
    /**
     * Constructs ...
     *
     *
     * @param minimum
     * @param baseline
     * @param maximum
     */
    public DataRange(float minimum, float baseline, float maximum) {
        this(minimum, baseline, maximum, true);
    }
    
        /**
     * Constructs ...
     *
     *
     * @param minimum
     * @param baseline
     * @param maximum
     */
    public DataRange(float minimum, float baseline, float maximum, boolean drawBaseline) {
        this.minimum = minimum;
        this.baseline = baseline;
        this.maximum = maximum;
        this.drawBaseline = drawBaseline;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public Type getType() {
        return type;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getMinimum() {
        return minimum;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getBaseline() {
        return baseline;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public float getMaximum() {
        return maximum;
    }

    /**
     * Method description
     *
     *
     * @return
     */
    public boolean isFlipAxis() {
        return flipAxis;
    }
    public boolean isDrawBaseline() {
        return drawBaseline;
    }

    public void setDrawBaseline(boolean drawBaseline) {
        this.drawBaseline = drawBaseline;
    }


}
