/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.remote;

//~--- non-JDK imports --------------------------------------------------------
import java.awt.HeadlessException;
import org.apache.log4j.Logger;

import org.broad.igv.feature.GenomeDescriptor;
import org.broad.igv.feature.GenomeManager;

//~--- JDK imports ------------------------------------------------------------

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;

import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import org.broad.igv.ui.IGVMainFrame;

/**
 *
 * @author jrobinso
 */
public class SequenceServletWrapper {

    /** Field description */
    public static boolean SEQUENCE_SERVER_AVAILALBLE = true;
    public static final int CONNECTION_TIMEOUT = 5000;
    private static Logger logger = Logger.getLogger(SequenceServletWrapper.class);

    /**
     *
     *
     * @param genome
     * @param chr
     * @param start
     * @param end
     *
     * @return
     */
    public static byte[] readBytes(String genome, String chr, int start, int end) {

        byte[] bytes = new byte[end - start + 1];

        if (!SEQUENCE_SERVER_AVAILALBLE) {
            return bytes;
        }

        GenomeDescriptor genomeDescriptor =
                GenomeManager.getInstance().getGenomeDescriptorMap().get(genome);
        String sequenceURL = genomeDescriptor.getSequenceLocation().replace(
                "broad.mit.edu",
                "broadinstitute.org");


        // TODO HACK: Remove when server genome archives are updated to new URL
        if (sequenceURL.contains("SequenceServlet")) {
            sequenceURL = sequenceURL.replace("SequenceServlet", "sequence");

        // if(!sequenceURL.endsWith("/")) {
        // sequenceURL += "/";
        // }
        // sequenceURL +=  genome;
        }


        try {

            URL url = new URL(sequenceURL);
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(CONNECTION_TIMEOUT);
            connection.setDoOutput(true);

            OutputStreamWriter out = new OutputStreamWriter(connection.getOutputStream());
            out.write("chr=" + chr);
            out.write("&start=" + start);
            out.write("&end=" + end);
            out.close();

            InputStream cis = connection.getInputStream();

            Timer connectionTimer = new Timer();
            connectionTimer.schedule(new ConnectionTimerTask(connection), CONNECTION_TIMEOUT);

            DataInputStream is =
                    new DataInputStream(new BufferedInputStream(cis));
            int offset = 0;
            int numRead = 0;
            while ((offset < bytes.length) && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                offset += numRead;
            }
            connectionTimer.cancel();
            is.close();

            return bytes;



        } catch (IOException ex) {

            // Log connection errors once per session to prevent filling the log
            if (SEQUENCE_SERVER_AVAILALBLE) {
                SEQUENCE_SERVER_AVAILALBLE = false;

                showUnavailableMessage();

                logger.error("Error retrieving sequence from : " + sequenceURL + ex.getMessage());
            }
            return null;
        }
    }

    private static void showUnavailableMessage() throws HeadlessException {
        JOptionPane.showMessageDialog(IGVMainFrame.getInstance(),
                "<html>The IGV server at the Broad Institute is currently unavailable.  " +
                "Features that require a reference sequence, <br>" +
                "such as displaying alignment mismatches, will be disabled.  " +
                "If this problem persists please <br>" +
                "send email to igv-help@broadinstitute.org");
    }

    static class ConnectionTimerTask extends TimerTask {

        URLConnection urlConn;

        ConnectionTimerTask(URLConnection urlConn) {
            this.urlConn = urlConn;
        }

        public void run() {
            try {
                urlConn.getInputStream().close();
                SEQUENCE_SERVER_AVAILALBLE = false;
                showUnavailableMessage();

            } catch (IOException ex) {
            }
        }
    };

}
