/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import org.broad.igv.data.ProcessingUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/**
 *
 * @author jrobinso
 */
public class SolexaBinaryBatchRunner {

    public static void main(String[] args) {

        Map<String, String> argMap = ProcessingUtils.parseArgs(args);

        File sourceDirectory = new File(argMap.get("-inputFile"));
        
        String filterString = argMap.get("-filter");
        
        Set<String> result = getSampleNames(sourceDirectory, filterString);
        System.out.println("# sample = " + result.size());
        
        File outputFile = new File(argMap.get("-outputFile"));
        File outputDir = (outputFile.isDirectory() ? outputFile : outputFile.getParentFile());

        for (String sampleName : result) {
            try {
                String [] tmp = replaceArg(args, "-filter", sampleName);

                outputFile = new File(outputDir, sampleName + ".h5");
                replaceArg(args, "-outputFile", outputFile.getCanonicalPath());

                IGVPreprocessor.main(tmp);
            } catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Set<String> getSampleNames(File sourceDirectory, final String filterString) {

        FilenameFilter filter = new FilenameFilter() {

            public boolean accept(File dir, String name) {
                return name.endsWith(".bin") &&
                        (!name.contains("_random") &&
                        (filterString == null || name.contains(filterString)));
            }
        };
        File[] files = sourceDirectory.listFiles(filter);

        LinkedHashSet<String> sampleNames = new LinkedHashSet();
        for (File file : files) {
            String[] tokens = file.getName().split("\\.");

            //String tmp = tokens[1];
            String name = tokens[1];
            int i = 2;
            while (!(tokens[i].equals("bin") || tokens[i].equals("cn"))) {
                name += "." + tokens[i];
                i++;
            }
            sampleNames.add(name);
        }
        return sampleNames;
    }

    private static String [] replaceArg(String[] args, String key, String newValue) {
        
        for (int i = 0; i < args.length - 1; i++) {
            if (args[i].equals(key)) {
                args[i + 1] = newValue;
                return args;
            }
        }
        //No previous value to replace.  Tack on the end
        String [] newArgs = new String [args.length + 2];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[newArgs.length - 2] = key;
        newArgs[newArgs.length - 1] = newValue;
        return newArgs;
        
    }
}
