/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import org.broad.igv.data.ProcessingUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.util.LinkedHashMap;
import org.broad.igv.track.TrackType;

/**
 *
 * @author jrobinso
 */
public class SnpProcessor {

    /**
     * Example: 
     *   NonOverlappingProcessor -dataType solexa  -inputDir C:\projects\gp-modules\modules\SnpViewer\data\solexa_2 -outputFile solexa.h5 -genome mm8
     * @param args
     * @throws java.lang.Exception
     * 
     *
     */
    public static void main(String args[]) throws Exception {


        LinkedHashMap<String, String> argsMap = ProcessingUtils.parseArgs(args);
        String name = argsMap.get("-name");
        String inputDirectory = argsMap.get("-inputDir");
        String outputFile = argsMap.get("-outputFile");
        String genome = argsMap.get("-genome");
        String span = argsMap.get("-windowSpan");
        String normalized = argsMap.get("-normalized");
        String maxZoomLevel = argsMap.get("-maxZoomLevel");

        // Format of location files
        boolean intLocations = false;
        String locationFormat = argsMap.get("-locationFormat");
        if (locationFormat != null) {
            intLocations = (locationFormat.equalsIgnoreCase("int"));
        }
        
        
        // Data format  (Solexa or not
        String dataFormat = argsMap.get("-dataFormat");
        boolean solexaFormat = (dataFormat != null && dataFormat.toUpperCase().equals("SOLEXA"));
       
        
        int maxZoom = 7;
        if (maxZoomLevel != null && maxZoomLevel.length() > 0) {
            try {
                maxZoom = Integer.parseInt(maxZoomLevel);
            } catch (NumberFormatException numberFormatException) {
                maxZoom = 7;
            }
        }
        final String filterString = argsMap.get("-filter");

        String typeString = argsMap.get("-type");

        TrackType type = TrackType.COPY_NUMBER;
        if (typeString != null) {
            try {
                type = TrackType.valueOf(typeString);

            } catch (Exception exception) {
            }
        }


        FilenameFilter filter = new FilenameFilter() {

            public boolean accept(File dir, String name) {
                return name.endsWith(".bin") &&
                        (!name.contains("_random")) &&
                        (filterString == null ||
                        name.contains(filterString));
            }
        };


        int wSpan = 1;
        if (span != null) {
            try {
                wSpan = Integer.parseInt(span);
            } catch (NumberFormatException numberFormatException) {
                System.out.println("span must be a number (" + span + ")");
                System.exit(-1);
            }
        }
        
        // Solex has a span of 25, unless entered otherwise.  1 is the default
        // and probably means the user neglected to change this in GP
        if(solexaFormat && wSpan == 1) {
            wSpan = 25;
        }

        int norm = 0;
        if (normalized != null) {
            try {
                norm = Integer.parseInt(normalized);
                System.out.println("normalized = " + norm);
            } catch (NumberFormatException numberFormatException) {
                System.out.println("normalized must be a number (" + norm + ")");
                System.exit(-1);
            }
        }

        boolean chipFormat = typeString.equalsIgnoreCase("solexa");

        SnpBinaryDataset ds = new SnpBinaryDataset(name, type, genome,
                inputDirectory, filter, chipFormat, intLocations);
        ds.setWindowSpan(wSpan);
        ds.setNormalized(norm != 0);

        System.out.println("Dataset loaded");
        System.out.flush();

        NonOverlappingProcessor pr = new NonOverlappingProcessor(ds);
        pr.setZoomMax(maxZoom);
        pr.process(outputFile);

    }
}
