/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import org.broad.igv.data.DataStatistics;
import cern.colt.list.DoubleArrayList;
import cern.jet.stat.quantile.DoubleQuantileFinder;
import cern.jet.stat.quantile.QuantileFinderFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedHashMap;

/**
 *
 * @author jrobinso
 */
public class ProcessingUtils {

    public ProcessingUtils() {
    }

    /**
     * locations - sorted array of genomic locations (base pairs)
     * chrLength - total chrLength in genomic coordinates (base pairs)
     * nBins - the number of bins to create.
     */
    /*public List<Bin> computeBins(long[] locations, int nBins, double binSize, long startLocation, long endLocation) {
    List<Bin> allBins = createBins(nBins, startLocation, binSize);
    // Allocate features to bins
    for (int i = 0; i < locations.length; i++) {
    int bin = (int) Math.min(allBins.size() - 1, (locations[i] - startLocation) / binSize);
    if (bin > 0 && bin < allBins.size()) {
    Feature f = new LocusScore()
    allBins.get(bin).addFeature(feature);
    }
    }
    List<Bin> occupiedBins = removeEmptyBins(allBins);
    return occupiedBins;
    }
     */
    /**
     * Compute some statistics for the input data
     *   TODO move to a utility class
     *   TODO take statis desired as input
     * @param data
     * @return
     */
    public DataStatistics computeStats(float[] data) {

        // Check for null or missing data.  Float.NaN is interpreted
        // as a placeholder for "no data.
        
        boolean noData = true;
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; i++) {
                if (!Float.isNaN(data[i])) {
                    noData = false;
                    break;
                }
            }
        }


        if (noData) {
            return DataStatistics.nullDataStat;
        } else {

            DataStatistics stats = new DataStatistics();

            // Check for array of NaNs
            DoubleArrayList al = new DoubleArrayList(2);
            al.add(0.1);
            al.add(0.5);
            al.add(0.9);
            al.add(0.98);
            DoubleQuantileFinder qf =
                    QuantileFinderFactory.newDoubleQuantileFinder(true, data.length,
                    0.001, 0.001, al.size(), null);


            double minStat = Double.MAX_VALUE;
            double maxStat = -Double.MAX_VALUE;
            double meanStat = 0;
            for (int i = 0; i < data.length; i++) {
                if (isValidData(data[i])) {
                    qf.add(data[i]);
                    minStat = Math.min(minStat, data[i]);
                    maxStat = Math.max(maxStat, data[i]);
                    meanStat += data[i];
                }
            }

            if (qf.size() > 0) {

                meanStat /= qf.size();
                double err2 = 0;
                for (int i = 0; i < data.length; i++) {
                    if (isValidData(data[i])) {
                        err2 += (data[i] - meanStat) * (data[i] - meanStat);
                    }
                }
                double stdDev = Math.sqrt(err2 / qf.size());

                DoubleArrayList quantiles2 = qf.quantileElements(al);
                stats.setMin(minStat);
                stats.setMax(maxStat);
                stats.setMean(meanStat);
                stats.setPercentile10(quantiles2.get(0));
                stats.setMedian(quantiles2.get(1));
                stats.setPercentile90(quantiles2.get(2));
                stats.setPercentile98(quantiles2.get(3));
                stats.setStdDev(stdDev);
            }
            
            return stats;

        }
    }

    /**
     * 
     * @param data
     * @return
     */
    public double computeMedian(float[] data) {

        DataStatistics stats = new DataStatistics();


        if (data.length > 0) {
            DoubleArrayList al = new DoubleArrayList();
            al.add(0.5);
            DoubleQuantileFinder qf =
                    QuantileFinderFactory.newDoubleQuantileFinder(true, data.length,
                    0.001, 0.001, al.size(), null);


            for (int i = 0; i < data.length; i++) {
                if (isValidData(data[i])) {
                    qf.add(data[i]);

                }
            }

            if (qf.size() > 0) {

                DoubleArrayList quantiles2 = qf.quantileElements(al);
                return quantiles2.get(0);
            }
        }
        return 0;
    }

    private boolean isValidData(float data) {
        //if (chipFormat) {
        //    return !Float.isNaN(data) && (data >= 0);
        //} else {
        return !Float.isNaN(data);
    //}
    }

    /** Dump the first N data values from the given file as a java formatted
     *  array.  Used for debugging
     *  and testing.
     * @param data
     * @return
     */
    public static void dump(File file, Class type, int nPoints) {

        BinaryReader reader = new BinaryReader();

        System.out.print("{");
        if (type == Long.class) {
            long[] values = reader.readLongs(file);
            for (int i = 0; i < nPoints; i++) {
                System.out.print(values[i]);
                if (i < nPoints - 1) {
                    System.out.print(", ");
                }
            }
            System.out.println("}");
        } else if (type == Float.class) {
            float[] values = reader.readFloats(file);
            for (int i = 0; i < nPoints; i++) {
                System.out.print(values[i]);
                if (i < nPoints - 1) {
                    System.out.print(", ");
                }
            }
            System.out.println("}");
        }
    }

    /** Count the number of points between start and end location.  Used
     * for debugging.
     *  and testing.
     * @param data
     * @return
     */
    public static void countPoints(File file, long startLocation, long endLocation) {

        BinaryReader reader = new BinaryReader();
        long[] values = reader.readLongs(file);
        int count = 0;
        for (int i = 0; i < values.length; i++) {
            if (values[i] >= endLocation) {
                break;
            }
            if (values[i] >= startLocation) {
                count++;
            }
        }
        System.out.println("Count= " + count);
    }

    public static void dumpPoints(File file, long startLocation, long endLocation) {

        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter("feature_dump_gt.txt"));
            BinaryReader reader = new BinaryReader();
            long[] values = reader.readLongs(file);
            for (int i = 0; i < values.length; i++) {
                if (values[i] >= endLocation) {
                    break;
                }
                if (values[i] >= startLocation) {
                    pw.println(values[i]);

                }
            }
        } catch (IOException ex) {
            ex.printStackTrace();
        } finally {
            pw.close();

        }
    }

    public static LinkedHashMap<String, String> parseArgs(String[] args) {
        LinkedHashMap<String, String> argMap = new LinkedHashMap();

        for (int i = 0; i < args.length; i++) {
            System.out.println(args[i]);

            String key = args[i];

            if (args[i].startsWith("-")) {
                if (i < args.length - 1) {
                    i++;

                    if (args[i].startsWith("-")) {
                        argMap.put(key, "");
                        i--;
                    } else {
                        argMap.put(key, args[i]);
                    }
                } else {
                    argMap.put(key, "");
                }
            } else {
                argMap.put(key, key);
            }
        }

        return argMap;
    }

    public static void main(String[] args) {
        long startLocation = 4568550;
        long endLocation = 4611950;
        dumpPoints(new File("test/data/es/chrX.snplocation.bin"), startLocation, endLocation);
    //dump(new File("test/data/es/chrX.snplocation.bin"), Long.class, 20);
    //dump(new File("test/data/es/chrX.ES.K27.bin"), Float.class, 20);
    }
}
