/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

/*
 * ResFileParser.java
 *
 * Created on October 18, 2007, 2:33 PM
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */
package org.broad.igv.preprocess.old;

import org.broad.igv.data.ProbeSet;
import org.broad.igv.data.ExpressionProbe;
import org.broad.igv.preprocess.old.*;
import org.broad.igv.preprocess.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author jrobinso
 */
public class ProbeListParser {

    /** Creates a new instance of ResFileParser */
    public ProbeListParser() {
    }

    public static ProbeSet parseFile(File probeFile) {


        ProbeSet probeSet = new ProbeSet();
        try {

            BufferedReader reader = new BufferedReader(new FileReader(probeFile));

            // Skip first row
            reader.readLine();

            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String probeId = tokens[0];
                String chr = tokens[1].trim();
                if (chr.startsWith("chr") && !chr.contains("random")) {
                    int start = Integer.parseInt(tokens[2]);
                    int end = Integer.parseInt(tokens[3]);

                    ExpressionProbe probe = new ExpressionProbe(probeId, probeId);

                    probe.setChr(chr);
                    probe.setStart(start);
                    probe.setEnd(end);
                    probeSet.add(probe);
                }
            }
            probeSet.sortProbeLists();

        } catch (FileNotFoundException ex) {
            ex.printStackTrace();
        } catch (IOException ex) {
            ex.printStackTrace();
        }
        return probeSet;

    }

    // TODO -- make this a unit test
    public static void main(String[] args) {
        String fn = "data/expression/WETime.rma.mapped";
        File file = new File(fn);
        System.out.println(file.getAbsolutePath());
        ProbeSet ds = parseFile(file);

        List<ExpressionProbe> probeList = ds.getProbes("chr1");
        for (int i = 0; i < 10; i++) {
            System.out.println(probeList.get(i));
        }
    }
}
