/*
 * The Broad Institute
 * SOFTWARE COPYRIGHT NOTICE AGREEMENT
 * This is copyright (2007-2009) by the Broad Institute/Massachusetts Institute 
 * of Technology.  It is licensed to You under the Gnu Public License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *    http://www.opensource.org/licenses/gpl-2.0.php
 *
 * This software is supplied without any warranty or guaranteed support
 * whatsoever. Neither the Broad Institute nor MIT can be responsible for its
 * use, misuse, or functionality.
*/

package org.broad.igv.preprocess.old;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import org.broad.igv.feature.GeneManager;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.feature.Feature;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.UCSCGeneTableParser;
import org.broad.igv.ui.MiscStuff;
import org.broad.igv.util.AsciiLineReader;

/**
 * Utlity to create a probe list from an affy annotation file
 * 
 * @author jrobinso
 */
public class ProbeListCreator {

    static String genome = "hg15";
    static File symbolFile = new File("/Volumes/xchip_tcga/gbm/visualization/MedPop/matched.brain.gi.symbol.2");
    static File outputFile = new File("/Volumes/xchip_tcga/gbm/visualization/MedPop/giprobes." + genome + ".tab");
    static File unfoundGenesFile = new File("/Volumes/xchip_tcga/gbm/visualization/MedPop/nogenes" + genome + "tab");

    public static void main(String [] args) throws IOException {
        createProbeMappingFile();
    }
    
    public static void createProbeMappingFile() throws IOException {
       
        
        GeneManager geneData = new GeneManager(genome, "Gene");
        String refGeneFile = genome + "_refFlat.txt";
        InputStream is2 = MiscStuff.class.getResourceAsStream("/resources/" + refGeneFile);
        AsciiLineReader reader2 = new AsciiLineReader(is2);
        List<Feature> genes = (new UCSCGeneTableParser(UCSCGeneTableParser.Type.REFFLAT)).loadFeatures(reader2);
        for (Feature gene : genes)
        {
            geneData.addGene(gene);
        }
        geneData.sortGeneLists();
        reader2.close();

        Map<String, String> probeToGene = loadProbeToGeneMap(symbolFile);

        PrintWriter pw2 = new PrintWriter(new FileWriter(unfoundGenesFile));
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        for (Map.Entry<String, String> entry : probeToGene.entrySet()) {
            String probe = entry.getKey();
            String geneName = entry.getValue();
            Feature gene = FeatureDB.getFeature(geneName);
            if(gene == null) {
                pw2.println(probe + "\t" + geneName);
            }
            else {
                pw.println(probe + "\t" + gene.getChromosome() + "\t" +
                        gene.getStart() + "\t" + gene.getEnd());
            }
        }
        pw.close();
    }
    
    public static Map<String, String> loadProbeToGeneMap(File file) throws FileNotFoundException, IOException {
        
        BufferedReader reader = new BufferedReader(new FileReader(file));
        
        LinkedHashMap<String, String> map = new LinkedHashMap();
        String nextLine = null;
        while((nextLine = reader.readLine()) != null) {
            String [] tokens = nextLine.split("\\s");
            map.put(tokens[0].trim(), tokens[1].trim());
        }
        return map;
        
    }

   
}

